#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QSettings settings("Team16","kde-paste");
    QString lng = settings.value("lang","cpp").toString();

#ifdef Q_WS_WIN
    QFile file("langs.txt");
#else
    QFile file("/opt/kde-paste/langs.txt");
#endif
         if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
             return;

         while (!file.atEnd()) {
             QString line = file.readLine();
             QStringList lang=QString(line).split("|");
             langs.append(lang);
             ui->comboBox->addItem(lang.at(1).trimmed());
             if (lng==lang.at(0).trimmed())ui->comboBox->setCurrentIndex(ui->comboBox->count()-1);
         }

         connect(ui->pushButton,SIGNAL(clicked()),this,SLOT(publish_click()));
        connect(ui->pushButton_2,SIGNAL(clicked()),this,SLOT(get_click()));
}

void MainWindow::get_click(){
QString line=ui->lineEdit->text();
bool ok;
int nmb;
nmb=line.toInt(&ok,10);
if (!ok){
    if (line.split("/").last().trimmed()!="")
    line="http://paste.kde.org/api/xml/"+line.split("/").last();
    else{
        line="http://paste.kde.org/api/xml/"+line.split("/").at(line.split("/").count()-2);
    }
}
else line="http://paste.kde.org/api/xml/"+line;
line+="/";


QUrl *nw=new QUrl(line);
QNetworkAccessManager *manager = new QNetworkAccessManager(this);
 connect(manager, SIGNAL(finished(QNetworkReply*)),
         this, SLOT(replyFinished2(QNetworkReply*)));
  manager->get(QNetworkRequest(*nw));

}
void MainWindow::replyFinished2(QNetworkReply* reply){
      if (reply->isFinished()){
QString text=reply->readAll();
text=text.split("<data>").last().split("</data>").first();
text.replace("&amp;","&");
text.replace("&lt;","<");
text.replace("&gt;",">");
text.replace("&quot;","\"");
ui->textEdit_2->setText(text);

}
}

void MainWindow::publish_click(){
    QUrl *nw=new QUrl("http://paste.kde.org/");
    nw->addQueryItem("paste_data",ui->textEdit->toPlainText().toAscii());
    nw->addQueryItem("paste_lang",langs.at(ui->comboBox->currentIndex()).at(0).trimmed().toAscii());
    nw->addQueryItem("api_submit","true");
    nw->addQueryItem("mode","xml");

    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
     connect(manager, SIGNAL(finished(QNetworkReply*)),
             this, SLOT(replyFinished(QNetworkReply*)));

    /* QByteArray data(QString("mode: xml\n"\
                     "api_submit: true\n"\
                     "paste_lang: "+langs.at(ui->comboBox->currentIndex()).at(0).trimmed()+"\n"\
                     "paste_data: " +ui->textEdit->toPlainText()).toAscii());*/
     manager->get(QNetworkRequest(*nw));

     QSettings settings("Team16","kde-paste");
     settings.setValue("lang",langs.at(ui->comboBox->currentIndex()).at(0).trimmed());

}


void MainWindow::replyFinished(QNetworkReply* reply){
    if (reply->isFinished()){
    QStringList txt=QString(reply->readAll()).split("\n");
    for (int i=0;i<txt.count();i++){
    QString text=txt.at(i);
    QRegExp reg("<id>(\\d+)</id>");
    if (reg.indexIn(text.trimmed())>-1){
    QString link="http://paste.kde.org/"+reg.cap(1);
    QClipboard *clipboard = QApplication::clipboard();
    clipboard->setText(link);
    QMessageBox msg;
    msg.setText("link http://paste.kde.org/"+reg.cap(1)+" is copied to clipboard");
    msg.exec();
}
}

}
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
