/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/

#include <QtGui/QX11Info>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <qstring.h>

#include "progressindicator.h"

static QString pi_atom( "_HILDON_WM_WINDOW_PROGRESS_INDICATOR" );

void setProgressIndicator( unsigned int wid, bool mode )
{
#ifdef MAEMO 
  Atom atom = XInternAtom(QX11Info::display(), pi_atom.toAscii().constData(), False);
  if (!atom) 
  {
    qWarning("Unable to obtain:  %s", pi_atom.toAscii().constData());
  }
  else
  {
    unsigned int val = mode ? 1 : 0;
    XChangeProperty( QX11Info::display(),wid,atom,
        XA_INTEGER, 32, PropModeReplace, 
        reinterpret_cast<unsigned char *>(&val),1);
  }
#endif
}
