/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef __PAGEVIEWWIDGET_H__
#define __PAGEVIEWWIDGET_H__

#include <QtGui>
#include <QTextBrowser>


/*
 *   PageViewWidget
 *            +
 *            |
 *         PageBrowser
 *           /       \
 *          /         \
 *         /           \
 *        /             \
 * QWebKitPageBrowser  QTextBrowserPageBrowser
 */

class Chm;

class PageViewWidget : public QTextBrowser
{
  Q_OBJECT

  public:
    PageViewWidget( QWidget* parent = 0 );
    virtual ~PageViewWidget();


    void keyPressEvent(QKeyEvent* event);

    bool  loadChmFile( const QString& filename );
    void  openPageNum( size_t page );

    const QString& fileName() const { return filename_; }
    Chm* chm() { return chm_; }

    int getScrollBarPos() const { return verticalScrollBar()->sliderPosition(); }
    void setScrollBarPos( int pos ) { verticalScrollBar()->setSliderPosition(pos); } 

    

  
    void nextPage();
    void prevPage();
    void zoomIn();
    void zoomOut();
    void bookmarkCurrentPage();
  
  protected:
    // from QTextBrowser - called internally
    QVariant loadResource(int type, const QUrl & name);
      
  private:
    // common method 
    QString makeURLabsolute ( const QString & url, bool set_as_base );
    bool  openPage (const QString& url);
  private:

//    LCHMFile* chm_;
    Chm*  chm_;
    QString filename_;
    QString baseUrl_;
    size_t page_;
};

#endif

