#ifndef __FINDDIALOG_H__
#define __FINDDIALOG_H__

/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <QDialog>

/*
 * Possible layout :
 *     Find : [             ] V |  X
 *
 *  HBox, 
 *    Label, EditBox, Button, Separator, Button
 *
 *
 */
class QLabel;
class QLineEdit;
class QPushButton;
class QListWidget;
class QVBoxLayout;
class QHBoxLayout;

class LCHMSearchEngine;
class Chm;

class FindDialog : public QDialog
{
  Q_OBJECT

  private:
    FindDialog( Chm& chm, QWidget* parent = 0 );
    virtual ~FindDialog();

  public :
    static int doFind( Chm& chm, const QPoint& pos, const QSize& sz,QWidget* parent = 0 );

  private slots:
    void startSearch();
    void abortSearch();
    void onProgressStep( int, const QString& );
    void selectedResult();


  private:
    int index_;
    Chm& chm_;
    
    
    QLineEdit*    text_;
    QPushButton*  ok_;
    QPushButton*  cancel_;
    QListWidget* results_;

    QVBoxLayout* vbox_;
    QHBoxLayout* hbox_;

};

#endif

