#ifndef __CHM_H__
#define __CHM_H__

/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/

#include <qstringlist.h>

#include <libchmsearchengine.h>
#include <libchmfile.h>
#include <chmtypes.h>

class Chm
{

  public:

    Chm();
    ~Chm();
  
//    const QString& fileName() const { return fileName_; }
    LCHMFile& chm() { return chm_; }
    bool loadFile( const QString& name );


    size_t getUrlPageNum( const QString& url ) const;

    
    ///////////////////////////////////////////////////////////////////////////
    QString getTopicByUrl( const QString& url  ) const 
    { 
      return chm_.getTopicByUrl(url); 
    }
    ///////////////////////////////////////////////////////////////////////////
    bool parseTableOfContents(QVector<LCHMParsedEntry>* vec ) 
    { 
      return chm_.parseTableOfContents( vec  ); 
    }
    ///////////////////////////////////////////////////////////////////////////
		bool getFileContentAsString( QString * str, const QString& url )
    {
      return chm_.getFileContentAsString( str, url );
    }
    ///////////////////////////////////////////////////////////////////////////
		bool getFileContentAsBinary( QByteArray * data, const QString& url )
    {
      return chm_.getFileContentAsBinary( data, url );
    }


    const QStringList& getSearchResults() const { return resultList_; }
    const QString& searchText() const { return searchText_; }
    bool search( const QString& text  );
    

    bool loadBookmarks();
    bool storeBookmarks();
    void deleteBookmark( size_t i );
    const QStringList& getBookmarks() const { return bookmarks_; }
    void bookmarkPage( const QString& url   );

    const QStringList& getRecentDocs() const { return recentDocs_; }
    const ChmEntryList& getToc() const { return tableOfContents_; }

    const QString& lastDocDir() const 
    {
      //return fileInfo_.absoluteDir().absolutePath();
      return lastDocDir_;
    }


  private:
    bool loadSearchResults();
    bool generateSearchIndex();
    bool loadSearchIndex();
    bool storeSearchResults( const QString& text );
    void createDataDir();

    bool loadRecentDocs();
    bool storeRecentDocs();
    bool addRecentDoc( const QString& doc );

    bool loadLastDocDir();
    bool storeLastDocDir();

    static bool loadStringList( const QString& fileName, QStringList& list );
    static bool storeStringList( const QString& fileName, const QStringList& list );

    
  private:
    mutable LCHMFile chm_;
    QFileInfo   fileInfo_;
    QDir docDir_;
    LCHMSearchEngine se_;

    ChmEntryList tableOfContents_;
    typedef QMap< QString, size_t> tocmap_t;
    tocmap_t urlMap_;



    QStringList resultList_;
    QStringList bookmarks_;
    QStringList recentDocs_;

    QString lastDocDir_;

    QString   searchText_;
};

#endif

