/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <QtGui>

#include "chm.h"
#include "resources.h"
#include "recentdocsdialog.h"

//////////////////////////////////////////////////////////////////////////
RecentDocsDialog::RecentDocsDialog(  QWidget* parent )
  : QDialog( parent ),
    index_(-1),
    vbox_( new QVBoxLayout() ),
    recentDocs_( new QListWidget(this) )
{
  setWindowTitle("Recent Documents");
  vbox_->addWidget( recentDocs_ );
  setLayout( vbox_ );
  connect( recentDocs_, SIGNAL(itemDoubleClicked(QListWidgetItem*)), this, SLOT(chooseRecentDoc()));
//  connect( this, SIGNAL(rejected()), this, SLOT(abortRecentDocs()) ); 
}


//////////////////////////////////////////////////////////////////////////
RecentDocsDialog::~RecentDocsDialog()
{
  while( recentDocs_->count() )
  {
    delete recentDocs_->takeItem(0);
  }
  delete vbox_;
  delete recentDocs_;
}

//////////////////////////////////////////////////////////////////////////////
int RecentDocsDialog::doRecentDocs( Chm& chm, const QPoint& pos, const QSize& sz, QWidget* parent )
{
  RecentDocsDialog dlg(parent);

  dlg.loadRecentDocs( chm );
  dlg.move( pos );
  dlg.resize( sz );

  dlg.exec();

  return dlg.index_;
}


//////////////////////////////////////////////////////////////////////////////
bool RecentDocsDialog::loadRecentDocs( const Chm& chm )
{
  bool result = false;

  // remove existing items from the list 
  while( recentDocs_->count() )
  {
    delete recentDocs_->takeItem(0);
  }

#ifdef KCHMVIEWER_DEBUG
    qDebug( "loading %d recent doc names", chm.getRecentDocs().count() );
#endif
  for( int i = 0; i < chm.getRecentDocs().count(); ++i )
  { 
    
    QString doc = chm.getRecentDocs()[i];

    QFileInfo fi ( doc );

#ifdef KCHMVIEWER_DEBUG
    qDebug( "adding to recent doc list: %s", doc.toAscii().constData() );
#endif

    QListWidgetItem* item = 
      new QListWidgetItem();

    item->setFlags(  Qt::ItemIsEnabled | Qt::ItemIsSelectable );
    item->setText( fi.completeBaseName() );
    item->setIcon( QIcon(iconRecentDocs()) );
    recentDocs_->addItem( item );

  }


  return result;
}


///////////////////////////////////////////////////////////////////////////////
void RecentDocsDialog::chooseRecentDoc()
{
  index_ = recentDocs_->currentRow();
  done( QDialog::Accepted );
}

///////////////////////////////////////////////////////////////////////////////
void RecentDocsDialog::abortRecentDocs()
{
#ifdef KCHMVIEWER_DEBUG
  qDebug("aborting RecentDocsDialog.");
#endif  
  done(QDialog::Rejected);
}

