/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <iostream>
#include <QtGui>
#include <libchmfile.h>
#include <libchmsearchengine.h>
#include "finddialog.h"
#include "resources.h"
#include "chm.h"

/**
 *
 *
 */
FindDialog::FindDialog( Chm& chm, QWidget* parent  )
  : QDialog(parent),
    index_(-1),
    chm_(chm),
    text_( new QLineEdit(this) ),
    ok_( new QPushButton(QPixmap( QPixmap(iconSearch()) ), 0, this ) ),
    cancel_( new QPushButton(QPixmap(iconStop()), 0, this ) ),
    results_( new QListWidget(this) ),
    vbox_( new QVBoxLayout() ),
    hbox_( new QHBoxLayout() )

{
  ok_->setFlat(true);
  cancel_->setFlat(true);
  
  //cancel_->setEnabled( false );

  hbox_->addWidget( text_ );
  hbox_->addWidget( ok_ );
  hbox_->addWidget( cancel_ );
  
  vbox_->addLayout( hbox_ );
  vbox_->addWidget( results_ );
  
  setLayout( vbox_ );

  connect( ok_, SIGNAL(clicked()), this, SLOT(startSearch()) ); 
  connect( cancel_, SIGNAL(clicked()), this, SLOT(abortSearch()) ); 
  //connect( this, SIGNAL(rejected()), this, SLOT(abortSearch()) ); 
//  connect( se_, SIGNAL( progressStep( int, const QString& ) ), this, SLOT( onProgressStep( int, const QString& ) ) );
  connect( results_, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(selectedResult()) );

  setWindowTitle( QString("Find") );

  const QStringList& rl = chm_.getSearchResults();

  for( int i = 0; i < rl.count(); ++i )
  {
    results_->addItem( chm_.getTopicByUrl( rl[i]) );
  }
}

/**
 *
 *
 */
FindDialog::~FindDialog()
{
  // remove existing items from the list 
  while( results_->count() )
  {
    delete results_->takeItem(0);
  }
  delete text_;
  delete ok_;
  delete cancel_;
  delete results_;

  delete hbox_;
  delete vbox_;
}

/**
 * static method
 *
 */
int FindDialog::doFind( Chm& chm, const QPoint& pos, const QSize& sz, QWidget* parent )
{
//  chm.loadSearchIndex();

  FindDialog dlg( chm, parent );

  dlg.text_->insert( chm.searchText() );

  dlg.move( pos );
  dlg.resize( sz ); 
  dlg.exec();

  return dlg.index_;
}
/**
 *
 *
 */
void FindDialog::startSearch()
{

  // load ( create first if required ) the search index
  bool result = chm_.search( text_->text() );

  if( result )
  {
    // remove existing items from the list 
    while( results_->count() )
    {
      delete results_->takeItem(0);
    }

    const QStringList& rl = chm_.getSearchResults();
    for( int i = 0; i < rl.count(); ++i )
    {
      results_->addItem( chm_.getTopicByUrl(rl[i]) );
    }
  }
}

/**
 *
 *
 */
void FindDialog::selectedResult( )
{
  index_ = results_->currentRow();
  done( QDialog::Accepted );
}
/**
 *
 *
 */
void FindDialog::onProgressStep( int pp, const QString& ss )
{
#ifdef KCHMVIEWER_DEBUG
    qDebug("search progress %02d, %s", pp, ss.toAscii().constData() );
#endif    
}

/**
 *
 *
 */
void FindDialog::abortSearch()
{
  index_ = -1;
  done( QDialog::Rejected  );
}

