#ifndef __BOOKMARKSDIALOG_H__
#define __BOOKMARKSDIALOG_H__

/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <QDialog>


class QListWidget;
class QListWidgetItem;
class QVBoxLayout;
class QPushButton;

class Chm;

class BookmarksDialog : public QDialog
{
  Q_OBJECT

  private:
    BookmarksDialog( Chm& chm, QWidget* parent =0 );
    ~BookmarksDialog();


  public:
    static int doBookmarks( Chm& chm, const QPoint& pos, const QSize& sz, QWidget* parent = 0 );

  private:
    bool loadBookmarks( const Chm& chm );

  private slots:
    void chooseBookmark( );
    void deleteSelectedBookmarks();
    void abort();

  private:
    int index_;
    Chm& chm_;
    QListWidget* bookmarks_;
    QVBoxLayout* vbox_;
    QPushButton* delete_;
};



#endif

