/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <QtGui>
#include <QListWidget>
#include "resources.h"
#include "contentswidget.h"

/*****************************************************************************
*
*/
ContentsWidget::ContentsWidget( QWidget* parent)
  : QWidget(parent),
    contents_(new QListWidget(this))
{
  QSize sz( screenWidth(), toolbarY() ) ;
  contents_->setMinimumSize( sz );
  contents_->setMaximumSize( sz );
  contents_->move( 0, 0);
  contents_->setUniformItemSizes( true );
  connect( contents_, SIGNAL(itemClicked(QListWidgetItem*)),this,SLOT(contentsItemSelected(QListWidgetItem*)) );
}


/*****************************************************************************
*
*/
ContentsWidget::~ContentsWidget()
{
  while( contents_->count() )
  {
    delete contents_->takeItem(0);
  }
  delete contents_;
}

/*****************************************************************************
*
*/
void ContentsWidget::populate( const ChmEntryList& lst )
{
  // remove existing items from the list 
  while( contents_->count() )
  {
    delete contents_->takeItem(0);
  }

  
  for ( int i = 0; i < lst.size(); ++i )
  { 
    //int indent = tableOfContents_[i].indent;
    //int url_size = tableOfContents_[i].urls.size();
    //QString url = tableOfContents_[i].urls.join("|");
    contents_->addItem( lst[i].name );
  }

}

/*****************************************************************************
*
*/
void ContentsWidget::contentsItemSelected( QListWidgetItem* item )
{
  emit selected( contents_->currentRow() );
}


