/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Port of KChmViewer ( www.kchmviewer.net ) to mobile platforms         *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/

#include <QtGui>

#include "bookmarksdialog.h"
#include "resources.h"
#include "chm.h"

//////////////////////////////////////////////////////////////////////////////
BookmarksDialog::BookmarksDialog( Chm& chm, QWidget* parent )
  : QDialog( parent ),
    index_(-1),
    chm_(chm),
    bookmarks_( new QListWidget(this) ),
    vbox_( new QVBoxLayout() ),
    delete_(new QPushButton( QPixmap(iconStop()), QString("Delete"), this  ) )
{
  vbox_->addWidget( delete_ );
  vbox_->addWidget( bookmarks_ );
  setLayout( vbox_ );
  setWindowTitle( "Bookmarks" );



  connect( bookmarks_, SIGNAL(itemDoubleClicked(QListWidgetItem*)), this, SLOT(chooseBookmark()));
  connect( delete_, SIGNAL(clicked()), this, SLOT(deleteSelectedBookmarks() ) );

//  connect( this, SIGNAL(rejected()), this, SLOT(abort()) ); 
}

//////////////////////////////////////////////////////////////////////////////
BookmarksDialog::~BookmarksDialog()
{
  while( bookmarks_->count() )
  {
    delete bookmarks_->takeItem(0);
  }
  delete delete_;
  delete vbox_;
  delete bookmarks_;
}

//////////////////////////////////////////////////////////////////////////////
int BookmarksDialog::doBookmarks( Chm& chm, const QPoint& pos, const QSize& sz, QWidget* parent )
{
  BookmarksDialog dlg(chm,parent);

  dlg.loadBookmarks( chm );
  dlg.move( pos );
  dlg.resize( sz );

  dlg.exec();

  return dlg.index_;
}

//////////////////////////////////////////////////////////////////////////////
bool BookmarksDialog::loadBookmarks( const Chm& chm )
{
  bool result = false;

  // remove existing items from the list 
  while( bookmarks_->count() )
  {
    delete bookmarks_->takeItem(0);
  }

  for( int i = 0; i < chm.getBookmarks().count(); ++i )
  { 
    
    QString topic = chm.getTopicByUrl( chm.getBookmarks()[i] );

#ifdef KCHMVIEWER_DEBUG
    qDebug( "adding to bookmark list: %s", topic.toAscii().constData() );
#endif

    QListWidgetItem* item = 
      new QListWidgetItem();
    item->setFlags( Qt::ItemIsUserCheckable | Qt::ItemIsEnabled | Qt::ItemIsSelectable );
    item->setText( topic );
    item->setIcon( QIcon(iconBookmark()) );
    item->setCheckState( Qt::Unchecked );
    bookmarks_->addItem( item );
  }


  return result;
}


//////////////////////////////////////////////////////////////////////////////
void BookmarksDialog::chooseBookmark()
{
  index_ = bookmarks_->currentRow();
#ifdef KCHMVIEWER_DEBUG
  qDebug("choosing bookmark %d", index_ );
#endif  
  done( QDialog::Accepted );
}

//////////////////////////////////////////////////////////////////////////////
void BookmarksDialog::deleteSelectedBookmarks()
{
  int cc = bookmarks_->count();
  for ( int i =0; i <  bookmarks_->count(); ++i )
  {
    QListWidgetItem* item = bookmarks_->item(i);    
    if ( item->checkState() == Qt::Checked )
    {
      delete bookmarks_->takeItem(i);
      chm_.deleteBookmark(i);
      --i;
    }
  }
  if( cc != bookmarks_->count() )
  {
    chm_.storeBookmarks(); 
  }
}
void BookmarksDialog::abort()
{
#ifdef KCHMVIEWER_DEBUG
  qDebug("aborting BookmarksDialog.");
#endif  
  done(QDialog::Rejected);
}

