/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#ifndef __PAGEVIEWWIDGET_H__
#define __PAGEVIEWWIDGET_H__

#include <QtGui>
#include <QTextBrowser>
#include "chmtypes.h"


class PageViewWidget : public QTextBrowser
{
  Q_OBJECT

  public:
    PageViewWidget( QWidget* parent = 0 );
    virtual ~PageViewWidget();

    bool  loadChmFile( const QString& filename );
    void  openPageNum( size_t page );
    bool  openPage (const QString& url);

    QVariant loadResource(int type, const QUrl & name);

    const ChmEntryList& getContents() const { return tableOfContents_; }

    int getScrollBarPos() const { return verticalScrollBar()->sliderPosition(); }
    void setScrollBarPos( int pos ) { verticalScrollBar()->setSliderPosition(pos); } 

  
    void nextPage();
    void prevPage();
    void zoomIn();
    void zoomOut();
    
      
  private:
    
    QString makeURLabsolute ( const QString & url, bool set_as_base );
  private:

    LCHMFile* chm_;
    ChmEntryList tableOfContents_;
    QString baseUrl_;
    size_t page_;
};

#endif

