/**************************************************************************
 *  Kchmviewer for Maemo5 - a CHM file viewer with broad language support *
 *  Copyright (C) 2009-2010 Max Kiva , max.kiva@gmail.com                 *
 *                                                                        *
 *  This program is free software: you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation, either version 3 of the License, or     *
 *  (at your option) any later version.                                   *
 *															                                  	      *
 *  This program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 **************************************************************************/
#include <iostream>
#include <QtGui>
#include <QListWidget>
#include "contentswidget.h"

ContentsWidget::ContentsWidget( QWidget* parent)
  : QWidget(parent),
    contents_(new QListWidget(this))
{
  contents_->setMinimumSize( QSize(800,480-56-70));
  contents_->setMaximumSize( QSize(800,400-56-70));
  contents_->move( 0, 0);
  contents_->setUniformItemSizes( true );

  connect( contents_, SIGNAL(itemClicked(QListWidgetItem*)),this,SIGNAL(selectedContentsItem()) );
}


ContentsWidget::~ContentsWidget()
{
}

void ContentsWidget::populate( const ChmEntryList& lst )
{
  // remove existing items from the list 
  while( contents_->count() )
  {
    delete contents_->takeItem(0);
  }

  
  for ( int i = 0; i < lst.size(); ++i )
  { 
    //int indent = tableOfContents_[i].indent;
    //int url_size = tableOfContents_[i].urls.size();
    //QString url = tableOfContents_[i].urls.join("|");
    contents_->addItem( lst[i].name );
  }

}

void ContentsWidget::contentsItemSelected()
{
}
