/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#include "OptionsDialog.h"
#include "kanadb.h"

#include <QBoxLayout>
#include <QComboBox>
#include <QLabel>
#include <QPushButton>

OptionsDialog::OptionsDialog(QWidget *parent) :
    QDialog(parent)
{
    setWindowTitle("Choose Kana Set");

    cbo_kset = new QComboBox();
    for (int i = 0; i < KANA_SET_COUNT; i++)
        cbo_kset->addItem(QString(get_kana_set_name(i)) + " (" +
                          QString::number(get_kana_set_len(i)) + " items)");

    QLabel* lbl_id_note = new QLabel("<strong>Note:</strong> Selecting 'OK' will reset the order of "
                                     "the active kana set, even if you haven't changed the active set.");
    lbl_id_note->setWordWrap(true);

    QPushButton* btn_ok = new QPushButton("OK");
    btn_ok->setFixedWidth(160);
    btn_ok->setDefault(true);
    connect(btn_ok, SIGNAL(clicked()), this, SLOT(accept()));
    QPushButton* btn_cancel = new QPushButton("Cancel");
    btn_cancel->setFixedWidth(160);
    connect(btn_cancel, SIGNAL(clicked()), this, SLOT(reject()));
    QHBoxLayout* layh_btns = new QHBoxLayout();
    layh_btns->addStretch(1);
    layh_btns->addWidget(btn_ok);
    layh_btns->addWidget(btn_cancel);

    QVBoxLayout* mainLayout = new QVBoxLayout();
    //Still big spacing in landscape mode: mainLayout->setSpacing(0);
    mainLayout->addWidget(cbo_kset);
    mainLayout->addWidget(lbl_id_note);
    mainLayout->addLayout(layh_btns);

    setLayout(mainLayout);
}

OptionsDialog::~OptionsDialog()
{

}
