/*

Kana of The Day -- Japanese kana learning application for Maemo Fremantle.
Copyright (C) 2012 M. Hossein Azadmanesh (mhazadmanesh2009@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/

#pragma once
#include <QMainWindow>

class QComboBox;
class QPushButton;
class QLabel;
class QHBoxLayout;
class QVBoxLayout;

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    void setOrientation(ScreenOrientation orientation);
    void showExpanded();

private:
    int current_kana;
    int current_kana_set;
    int* current_permtab;

    QLabel* lbl_kset;
    QLabel* lbl_roma;
    QLabel* lbl_hira;
    QLabel* lbl_kata;

    QPushButton* btn_hide;
    QPushButton* btn_reveal;

    QHBoxLayout* layh_roma;
    QVBoxLayout* layv_hira;
    QVBoxLayout* layv_kata;
    QHBoxLayout* layh_btns;

    void CreateMenus();
    void CreateUI();
    void RelayoutUI(); /// At the start and when orientation changes.

    int orientationPreviouslyWas;
    void resizeEvent(QResizeEvent*);
    void closeEvent(QCloseEvent*);
    void keyReleaseEvent(QKeyEvent* event);

    static const int landscapeSwipeSensitivity = 200;
    static const int portraitSwipeSensitivity = 150;
    int swipeSensitivity;
    int swipeAction;
    int mouseStartX;
    int initialBtnPrevWidth;
    int initialBtnNextWidth;
    void mousePressEvent(QMouseEvent* event);
    void mouseReleaseEvent(QMouseEvent* event);
    void mouseMoveEvent(QMouseEvent* event);


    QString configFilePath;
    void ReadPermFromFile();
    void WritePermToFile();

public slots:
    void ShowKanaSetDialog();
    void ShowQuickHelp();
    void ShowAbout();

    void HideRomaji();
    void ShowRomaji();

    void ShowKana();
    void NextKana();
    void PrevKana();
};
