#include <QContactManager>
#include "contactsthreadworker.h"
#include "k9call.h"

using namespace QtMobility;

ContactsThreadWorker::ContactsThreadWorker(k9call* k)
    : QThread(0)
{
	// Setup connections
	connect(this, SIGNAL(updateContacts(QList<QtMobility::QContact>)), 
	        k, SLOT(updateContacts(QList<QtMobility::QContact>)), Qt::QueuedConnection);

	// Setup thread
	this->start(IdlePriority);
	this->moveToThread(this);
}

void ContactsThreadWorker::run()
{
    this->exec();
}

void ContactsThreadWorker::syncContacts()
{
	qDebug() << "Sync Contacts ThreadId " << (int)QThread::currentThreadId();
  QContactManager m;
	QContactFetchHint hint;
	QContactFetchHint::OptimizationHints optimizations = 0;
	optimizations |= QContactFetchHint::NoBinaryBlobs;
	optimizations |= QContactFetchHint::NoRelationships;
	hint.setOptimizationHints(optimizations);
	emit updateContacts(m.contacts(QList<QContactSortOrder>(), hint));
}

void ContactsThreadWorker::syncContactIds()
{
	qDebug() << "Sync Id ThreadId " << (int)QThread::currentThreadId();
    QContactManager m;
	emit updateContactIds(m.contactIds());
}
