/*
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <QDebug>
#include "t9trie.h"

QString T9Trie::T9Value ( const QString& str )
{
	int i, len = str.length();
	QString result;
	result.reserve(len);
	for(i = 0; i < len; i++) {
		result.append(QVariant(T9Value(str[i])).toString());
	}
	return result;
}

bool T9Trie::insert ( const QChar* key, QtMobility::QContactLocalId id)
{
    if ( key->isNull() )
    {
        list.insert ( id );
        return false;
    }

    int t9 = T9Value ( *key );
    if ( t9 == -1 )
        return insert ( key+1, id );

    if ( children[t9] == NULL )
        children[t9] = new T9Trie();

    children[t9]->insert ( key+1, id );
    return true;
}

QSet<QtMobility::QContactLocalId> T9Trie::lookup ( const QChar* key )
{
    if ( key->isNull() )
    {
        QSet<QtMobility::QContactLocalId> set = list;
        for ( int i = 0; i < NUM_CHILDREN; i++ )
        {
            if ( children[i] )
                set = set.unite ( children[i]->lookup ( key ) );
        }
        return set;
    }

    int digit = key->digitValue();
    if ( digit == -1 || children[digit] == NULL )
        return QSet<QtMobility::QContactLocalId>();

    return children[digit]->lookup ( key+1 );
}
