#ifndef CONTACTSTHREADWORKER_H
#define CONTACTSTHREADWORKER_H

#include <QtCore>
#include <QContact>
#include <QContactId>
#include <QContactManager>

using namespace QtMobility;

class k9call;

class ContactsThreadWorker : public QThread
{
    Q_OBJECT

public:
    ContactsThreadWorker(k9call* k);
    void run();

signals:
    void updateContacts(QList<QtMobility::QContact>);
    void updateContactIds (QList< QtMobility::QContactLocalId >);

public slots:
    void syncContacts();
    void syncContactIds();

private:
	QtMobility::QContactManager m_Manager;
};

#endif // CONTACTSTHREADWORKER_H
