#!/usr/bin/env python
import gobject, dbus, time
from dbus.mainloop.glib import DBusGMainLoop
import os, sys
import actions
import logging
from daemon import daemon

######### Set these Configuration Options #######################################################
secret="123456"																											#
# Define the different notifications that the 																	#
#  device can receive																									#
notifications=['email','sms']																							#
# Set user account - see install.txt for details																#
account = "/org/freedesktop/Telepathy/Connection/gabble/jabber/USERNAMESTRINGHERE"					#
#################################################################################################

# Create list of last notification times
lastTime=["0"]*len(notifications)

# Logging
LogPath    = '/tmp'
LogFile    = 'jpush.log'
logging.basicConfig(filename = '%s/%s' % (LogPath, LogFile),
					level    = logging.DEBUG,
					format   = 'JPush %(levelname)s: %(message)s (%(asctime)s)',
					datefmt  = '%d-%m-%Y %H:%M:%S')

# From: http://telepathy.freedesktop.org/wiki/DTube%20Tutorial%20Example
def db2p(db):
	if type(db)==dbus.Struct:
		return tuple(db2p(i) for i in db)
	if type(db)==dbus.Array:
		return [db2p(i) for i in db]
	if type(db)==dbus.Dictionary:
		return dict((db2p(key), db2p(value)) for key, value in db.items())
	if type(db)==dbus.String:
		return db+''
	if type(db)==dbus.UInt32:
		return db+0
	if type(db)==dbus.Boolean:
		return db==True
	return ('type: %s'%type(db), db)

def getCommand(dictionary):
	dictString = str(db2p(dictionary))
	dictString = dictString[dictString.find(secret):dictString.find("!")]
	return dictString

def between(beginning, end, data):
	beginningPos = data.find(beginning)
	if beginningPos == -1:		# Make sure it exists!
		return
	beginningPos =  beginningPos + len(beginning)
	result = data[beginningPos:len(data)]
	endPos = result.find(end)
	if endPos == -1:			# Make sure it exists!
		return
	result = result[:endPos]
	return result

def handle_presence(args):
	global lastTime		# Is this needed, or is the global version used by default?
	global notifications
	command = getCommand(args)
	if command != "":
		logging.debug(command)		# DEBUG
		### Go through list of different commands
		for index, notification in enumerate(notifications):
			curTime = between("<" + notification + "=", ">", command)
			if curTime != lastTime[index] and curTime != "0":
				lastTime[index] = curTime
				# Run correct function
				function=getattr(actions,notification)
				function(curTime)
				logging.info("Checking for new " + notification + ". Notification Sent: " + time.ctime(float(curTime)))
				
class MyDaemon(daemon):
	def run(self):
		logging.info("starting")
		DBusGMainLoop(set_as_default=True)
		bus = dbus.SessionBus()
		bus.add_signal_receiver(handle_presence, 'PresencesChanged', 'org.freedesktop.Telepathy.Connection.Interface.SimplePresence', None, account)
		gobject.MainLoop().run()

if __name__ == '__main__':
	# Daemonize!
	daemon = MyDaemon('/tmp/JPush.pid')
	if len(sys.argv) == 2:
		if sys.argv[1] == "start":
			daemon.start()
		elif sys.argv[1] == "stop":
			daemon.stop()
		elif sys.argv[1] == "restart":
			daemon.restart()
		elif sys.argv[1] == "status":
			daemon.status()
		else:
			print "Unknown command"
			sys.exit(2)
		sys.exit(0)
	else:
		print "usage: %s start | stop | restart | status" % sys.argv[0]
		sys.exit(2)
