/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef LISTWIDGET_H
#define LISTWIDGET_H

#include <QtGui/QTableWidget>
#include <QtCore/QMap>
#include <QtCore/QVariant>

class ListWidget : public QTableWidget
{
    Q_OBJECT

public:
    ListWidget(QWidget* parent = 0);
    void addWidget(QWidget* widget, QVariant const& data);
    QVariant getData(int index) const;
    QWidget* getWidget(int index) const;

signals:
    void itemClicked(int index);

public slots:
    void clear();

private slots:
    void handleClick(int index);

private:
    QTableWidget* widget_;
    QMap<int, QVariant> data_;
    QMap<int, QWidget*> widgets_;
};

#endif
