/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef CALLLISTENER_H
#define CALLLISTENER_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtGui/QLabel>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusObjectPath>
#include "informationbox.h"
#include "source.h"

class CallListener: public QObject
{
    Q_OBJECT

public:
    CallListener();
    ~CallListener();
    bool begin();
    void end();
    static const int REQUEST_TIMEOUT = 8000;
    static const int BANNER_DELAY = 350;
    static const int SEARCH_RETRIES = 2;
    static const int CONNECT_RETRIES = 1;
    static const int CONNECTION_LOOKUP_RETRIES = 7;
    static const int GPRS_SCANS = 2;
    static const int WLAN_SCANS = 4;
    static const int WAIT_BETWEEN_RETRIES = 400;
    static const int ERROR_BANNER_TIMEOUT = 4500;

protected:
    virtual void timerEvent(QTimerEvent* event);

private slots:
    void requestFinished(QVector <Source::Result> const& results, Source::SearchDetails const& details, bool error);
    void incomingCall(QDBusObjectPath path, QString numbe);
    void callTerminate();
    void showTimedMessage();
    void handleAnswer();
    void closeConnection();

private:
    Q_DISABLE_COPY(CallListener);

    struct CallDetails
    {
        QString number;
        Source::Result result;
        bool answered;
        unsigned int time;
    };

    void search(Source::SearchDetails const& details);
    void showResult(QString const& text);
    void showDelayedResult(QString const& text, int delay);
    void searchInit();
    void searchClose();
    bool handleConnection();
    void showError(QString const& msg, int delay = 0);
    bool is3g();
    void sleep(int ms);
    void sendRetrySignal(QString const& iap, bool retry);
    QString createResult(QString const& name, QString const& street, QString const& city);
    QString timedMessage_;
    Source* source_;
    Source::SourceId sourceId_;
    QMap<QString, QString> sourceConfig_;
    bool closeConnection_;
    bool initialized_;
    InformationBox* box_;
    QLabel* label_;
    static QDBusConnection systemBus_;
    int retries_;
    int timer_;
    CallDetails* currentCall_;
};

#endif // CALLLISTENER_H
