/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OVIMAPS_H
#define OVIMAPS_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QStringList>

class OviMaps : public QObject
{
    Q_OBJECT

public:

    struct Address
    {
        QString street;
        QString number;
        QString zipCode;
        QString city;
        QString country;
    };

    struct Location
    {
        double latitude;
        double longitude;
    };

    static int const TIMEOUT = 10000;

    OviMaps(QObject* parent = 0);
    bool addressToLocations(Address const& address, QList<Location>& locations);
    bool locationToAddresses(Location const& location, QList<Address>& address);
    bool openMaps(Address const& address);
    bool openMaps(Location const& location);

protected:
    virtual void timerEvent(QTimerEvent* event);

private slots:
    void handleAddressToLocationsReply(QList<OviMaps::Location>);
    void handleLocationToAddressesReply(QList<QStringList> addresses);

private:
    bool waitSignal();
    QList<Location>* locationsTarget_;
    QList<Address>* addressesTarget_;
    bool ready_;
    int timer_;

};

#endif
