/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <QtGui/QApplication>
#include <QtGui/QDesktopWidget>
#include <QtGui/QHeaderView>
#include <QtCore/QDebug>
#include "listwidget.h"

ListWidget::ListWidget(QWidget* parent): QTableWidget(parent)
{
    connect(this, SIGNAL(cellClicked(int, int)), this, SLOT(handleClick(int)));
    setColumnCount(1);
    verticalHeader()->hide();
    horizontalHeader()->hide();
    setColumnWidth(0, QApplication::desktop()->availableGeometry().width() - 10);
    setSelectionMode(QAbstractItemView::SingleSelection);
}

void ListWidget::addWidget(QWidget* widget, QVariant const& data)
{
    int row = rowCount();
    setRowCount(row + 1);
    setCellWidget(row, 0, widget);
    data_[row] = data;
    widgets_[row] = widget;
    resizeRowToContents (row);
}

QVariant ListWidget::getData(int index) const
{
    if(data_.find(index) != data_.end())
    {
        return data_[index];
    }

    return QVariant();
}

QWidget* ListWidget::getWidget(int index) const
{
    if(widgets_.find(index) != widgets_.end())
    {
        return widgets_[index];
    }

    return 0;
}

void ListWidget::clear()
{
    QTableWidget::clear();
    data_.clear();
    widgets_.clear();
    setRowCount(0);
}

void ListWidget::handleClick(int index)
{
    clearSelection();
    emit itemClicked(index);
}
