/*
 * This file is part of Jenirok.
 *
 * Jenirok is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Jenirok is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jenirok.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef SOURCECORECONFIG_H
#define SOURCECORECONFIG_H

#include <QtCore/QMap>
#include <QtCore/QString>
#include "source.h"

class SourceCoreConfig
{

public:

    static SourceCoreConfig* getCoreConfig(Source::SourceId id);
    SourceCoreConfig();
    virtual ~SourceCoreConfig();
    virtual bool apply(Source* source) = 0;
    virtual void getConfig(QMap<QString, QString>& config) = 0;
    virtual void loadFromConfig(QMap<QString, QString> const& config) = 0;
    virtual void store() = 0;
    virtual bool readyToSearch() = 0;
};

#endif
