/*
 * test-jammer
 *
 * This file is part of JamMo.
 *
 * This is for testing Jammer.
 * 	
 */
#include <meam/jammo-meam.h>
#include <chum/jammo-chum.h>
#include <meam/jammo-sample.h>
#include <meam/jammo-editing-track.h>
#include <glib-object.h>
#include <ctype.h>
#include <math.h>
#include <tangle.h>

#include "../jammo.h"
#include "jammer-accelerometer.h"
#include "jammer-emmafile.h"

#include "jammer_view.h"
#include "../../configure.h"

//All global vars Jammer uses TODO: remember to sync with g_free after exit (!important).

#define BUFFER_SIZE 6


static int selectedKitNum = 1; //0-> elec, 1->eth1, 2->eth2, 3->popk  etc

static gboolean isJammerPlaying; //do we read accelerometer values? (TRUE/FALSE)

static gboolean isJammerRecording;

static ClutterActor *btnSet3 = NULL;	///roller container

static ClutterActor *btnSet4 = NULL; ///piano container

static double sliderposx = 15.0; ///keeps track with roller x pos

static int jammerCounter = 0; ///counting how many loops jammer is running

static int motionBuffer[BUFFER_SIZE][3]; //buffer for calculating movement: 0 is the most recent event

static guint loop_id; ///accel read loop
///JammoSample for playing the sounds (need 3 of them)
static JammoSample* jammerSample0; 
static JammoSample* jammerSample1;
static JammoSample* jammerSample2;

typedef struct 
{
	int id;		//numeric id (0,1,2 ... )
	ClutterActor *instrumentImg;	
	gchar avatarfile[25];	//png filename 
	gchar folder[4];	//folder for sounds
	gboolean isMelodic;
} JammerInstruments;

static JammerInstruments instr[8];	//using 8 instruments in this build

static const gchar* melodicSounds[] = {NULL, NULL, NULL}; //assigned notes of melodic instruments

static int melodicSoundsIndex = 0; ///keeps track that melodic sounds are assigned //3 for full 

static int nextmelodicSoundsIndex = 0; ///next free melodic sound

static JammoEditingTrack* jammer_editing_track;
static JammoSequencer* jammer_sequencer;

///end of global vars TODO::free them all in exit 

//////JAMMER

static void playSound(int i){
	if (!instr[selectedKitNum].isMelodic){	
		if (i == 0){	
			jammo_sample_play(jammerSample0);
			if (isJammerRecording){
				jammo_editing_track_add_sample(jammer_editing_track, jammerSample0, jammo_sequencer_get_position(jammer_sequencer));
			}
		}else if (i == 1){
			jammo_sample_play(jammerSample1);
			if (isJammerRecording){
				jammo_editing_track_add_sample(jammer_editing_track, jammerSample1, jammo_sequencer_get_position(jammer_sequencer));
			}
		}else{
			jammo_sample_play(jammerSample2);
			if (isJammerRecording){
				jammo_editing_track_add_sample(jammer_editing_track, jammerSample2, jammo_sequencer_get_position(jammer_sequencer));
			}
		}
	}else{
		if (melodicSoundsIndex == 3){
			if (i == 0){	
				jammo_sample_play(jammerSample0);
				if (isJammerRecording){
					jammo_editing_track_add_sample(jammer_editing_track, jammerSample0, jammo_sequencer_get_position(jammer_sequencer));
				}
			}else if (i == 1){
				jammo_sample_play(jammerSample1);
				if (isJammerRecording){
					jammo_editing_track_add_sample(jammer_editing_track, jammerSample1, jammo_sequencer_get_position(jammer_sequencer));
				}
			}else{
				jammo_sample_play(jammerSample2);
				if (isJammerRecording){
					jammo_editing_track_add_sample(jammer_editing_track, jammerSample2, jammo_sequencer_get_position(jammer_sequencer));
				}
			}	
		}
	}
}

static void setSoundKit(){
	char *file0;
	char *file1;
	char *file2;
	isJammerPlaying = TRUE;
	if (!instr[selectedKitNum].isMelodic){	
		file0 = g_build_filename(JAMMERSOUNDPATH, instr[selectedKitNum].folder, "/0.wav", NULL);
		file1 = g_build_filename(JAMMERSOUNDPATH, instr[selectedKitNum].folder, "/1.wav", NULL);
		file2 = g_build_filename(JAMMERSOUNDPATH, instr[selectedKitNum].folder, "/2.wav", NULL);
		jammerSample0 = jammo_sample_new_from_file_with_sequencer(file0, jammer_sequencer);
		jammerSample1 = jammo_sample_new_from_file_with_sequencer(file1, jammer_sequencer);
		jammerSample2 = jammo_sample_new_from_file_with_sequencer(file2, jammer_sequencer);
	}else{
		file0 = g_strdup_printf("%s%s/%s_%s.ogg", JAMMERSOUNDPATH,instr[selectedKitNum].folder, instr[selectedKitNum].folder,melodicSounds[0]);
		file1 = g_strdup_printf("%s%s/%s_%s.ogg", JAMMERSOUNDPATH,instr[selectedKitNum].folder, instr[selectedKitNum].folder,melodicSounds[1]);
		file2 = g_strdup_printf("%s%s/%s_%s.ogg", JAMMERSOUNDPATH,instr[selectedKitNum].folder, instr[selectedKitNum].folder,melodicSounds[2]);
		jammerSample0 = jammo_sample_new_from_file_with_sequencer(file0, jammer_sequencer);
		jammerSample1 = jammo_sample_new_from_file_with_sequencer(file1, jammer_sequencer);
		jammerSample2 = jammo_sample_new_from_file_with_sequencer(file2, jammer_sequencer);
	}
}



//TRUE for up(-), FALSE for down (+)
static void moveSlider(gboolean direction){
	///move the slider	
	if (direction){	
		sliderposx = sliderposx - 120.0;
	}else{
		sliderposx = sliderposx + 120.0;
	}
	clutter_actor_animate(CLUTTER_ACTOR(btnSet3), CLUTTER_LINEAR, 500, 
				"x", sliderposx,
				NULL);
}


static void setSoundKitNum(int s){
	isJammerPlaying = FALSE;	
	gboolean direction = FALSE;
	if (selectedKitNum > s){
		direction = FALSE;
	}else{
		direction = TRUE;
	}
	selectedKitNum = s;
	setSoundKit();
	moveSlider(direction);
	if (instr[s].isMelodic && !CLUTTER_ACTOR_IS_VISIBLE(btnSet4) ){
		clutter_actor_show_all(btnSet4);
	}
	if (!instr[s].isMelodic && CLUTTER_ACTOR_IS_VISIBLE(btnSet4) ){
		clutter_actor_hide_all(btnSet4);
	}
	isJammerPlaying = TRUE;
}

static int sort1(const void *x1, const void *y1) {
    return (*(int*)x1 - *(int*)y1);
}

static int distance(int pointA[3],int pointB[3] ){
    double temp;
    temp = sqrt(pow((pointA[0]-pointB[0]),2)+pow((pointA[1]-pointB[1]),2)+pow((pointA[2]-pointB[2]),2));
    return (int)temp;
}


static int metro(int pointA[BUFFER_SIZE] ){
    int i;
    double temp=0;
    for (i=0;i<BUFFER_SIZE;i++){
        temp =+ pow(pointA[i],2);
    }
    return (int)sqrt(temp);
}

static int motion_detect(int e, int firsttime){
	int sample_size = 10;
	int k_nearest = 5; //k nearest

///Training data
    //MovemementA training data (face down)
    //int fd[10][BUFFER_SIZE][3];
    //par a: set number
    //par b: movement number
    //par c: position
    int fd[sample_size][sample_size][3];
    fd[0][0][0] = -18;fd[0][0][1] = -72;fd[0][0][2] = 954;
    fd[0][1][0] = -16;fd[0][1][1] = -79;fd[0][1][2] = 959;
    fd[0][2][0] = -19;fd[0][2][1] = -85;fd[0][2][2] = 944;
    fd[0][3][0] = -29;fd[0][3][1] = 49;fd[0][3][2]= 905;
    fd[0][4][0] = -47;fd[0][4][1] = 184;fd[0][4][2] = 893;
    fd[0][5][0] = -45;fd[0][5][1] = 271;fd[0][5][2] = 791;
    fd[0][6][0] = -36;fd[0][6][1] = 351;fd[0][6][2] = 693;
    fd[0][7][0] = -21;fd[0][7][1] =  425;fd[0][7][2] = 612;
    fd[0][8][0] = -15;fd[0][8][1] = 490;fd[0][8][2] = 541;
    fd[0][9][0] = -6;fd[0][9][1] = 549;fd[0][9][2] = 476;
    fd[1][0][0] = 36; fd[1][0][1] = -72; fd[1][0][2] = 972;
    fd[1][1][0] =37;fd[1][1][1] = -72;fd[1][1][2] = 973;
    fd[1][2][0]= 36;fd[1][2][1]= -73;fd[1][2][2]= 967;
    fd[1][3][0] = 25; fd[1][3][1] =  -15; fd[1][3][2] = 911;
    fd[1][4][0] = 11;fd[1][4][1] =  116;fd[1][4][2] = 888;
    fd[1][5][0] = -4; fd[1][5][1] = 208; fd[1][5][2] = 856;
    fd[1][6][0] = -7;fd[1][6][1] = 297;fd[1][6][2] = 772;
    fd[1][7][0] = -6;fd[1][7][1] = 375;fd[1][7][2] = 705;
    fd[1][8][0] = -7;fd[1][8][1] = 445;fd[1][8][2] = 645;
    fd[1][9][0]=-11; fd[1][9][1]= 506; fd[1][9][2]= 594;
    fd[2][0][0]=36;fd[2][0][1]= -72;fd[2][0][2]= 972;
    fd[2][1][0]=34;fd[2][1][1]= -75;fd[2][1][2]= 973;
    fd[2][2][0]=32; fd[2][2][1]= -78; fd[2][2][2]= 971;
    fd[2][3][0]=18;fd[2][3][1]= -25;fd[2][3][2]= 897;
    fd[2][4][0]=1;fd[2][4][1]= 188;fd[2][4][2]= 873;
    fd[2][5][0]=8;fd[2][5][1]= 273;fd[2][5][2]= 791;
    fd[2][6][0]=3;fd[2][6][1]= 350;fd[2][6][2]= 708;
    fd[2][7][0]=0;fd[2][7][1]= 423;fd[2][7][2]= 628;
    fd[2][8][0]=-5; fd[2][8][1]= 483; fd[2][8][2]= 568;
    fd[2][9][0]=-4;fd[2][9][1]= 542;fd[2][9][2]= 504;
    fd[3][0][0]=36;fd[3][0][1]= -72;fd[3][0][2]= 972;
    fd[3][1][0]=34;fd[3][1][1]= -73;fd[3][1][2]= 972;
    fd[3][2][0]=23;fd[3][2][1]= -76; fd[3][2][2]=945;
    fd[3][3][0]=17;fd[3][3][1]= 28;fd[3][3][2]= 913;
    fd[3][4][0]=-20;fd[3][4][1]= 174;fd[3][4][2]= 909;
    fd[3][5][0]=-25;fd[3][5][1]= 270;fd[3][5][2]= 809;
    fd[3][6][0]=-26;fd[3][6][1]= 347;fd[3][6][2]= 724;
    fd[3][7][0]=-23;fd[3][7][1]= 414;fd[3][7][2]= 644;
    fd[3][8][0]=-24;fd[3][8][1]= 480;fd[3][8][2]= 574;
    fd[3][9][0]=-25;fd[3][9][1]= 540;fd[3][9][2]= 511;
    fd[4][0][0]=72; fd[4][0][1]= -90; fd[4][0][2]= 1026;
    fd[4][1][0]=75;fd[4][1][1]= -90;fd[4][1][2]= 1020;
    fd[4][2][0]=65;fd[4][2][1]= -84;fd[4][2][2]= 990;
    fd[4][3][0]=42;fd[4][3][1]= 3;fd[4][3][2]= 948;
    fd[4][4][0]=30;fd[4][4][1]= 150;fd[4][4][2]= 907;
    fd[4][5][0]=18;fd[4][5][1]= 243;fd[4][5][2]= 852;
    fd[4][6][0]=25;fd[4][6][1]= 326;fd[4][6][2]= 750;
    fd[4][7][0]=31;fd[4][7][1]= 399; fd[4][7][2]=667;
    fd[4][8][0]=29;fd[4][8][1]= 470;fd[4][8][2]= 589;
    fd[4][9][0]=29;fd[4][9][1]= 531;fd[4][9][2]= 522;
    fd[5][0][0]=54;fd[5][0][1]= -36;fd[5][0][2]= 954;
    fd[5][1][0]=52;fd[5][1][1]= -36;fd[5][1][2]= 961;
    fd[5][2][0]=50;fd[5][2][1]= -41;fd[5][2][2]= 953;
    fd[5][3][0]=48;fd[5][3][1]= 22;fd[5][3][2]= 906;
    fd[5][4][0]=43;fd[5][4][1]= 178;fd[5][4][2]= 867;
    fd[5][5][0]=31;fd[5][5][1]= 264;fd[5][5][2]= 819;
    fd[5][6][0]=29;fd[5][6][1]= 347;fd[5][6][2]= 726;
    fd[5][7][0]=27;fd[5][7][1]= 420;fd[5][7][2]= 639;
    fd[5][8][0]=29;fd[5][8][1]= 489;fd[5][8][2]= 564;
    fd[5][9][0]=27;fd[5][9][1]= 546;fd[5][9][2]= 504;
    fd[6][0][0]=36;fd[6][0][1]= -126;fd[6][0][2]= 1008;
    fd[6][1][0]=32;fd[6][1][1]= -124;fd[6][1][2]= 1004;
    fd[6][2][0]=30; fd[6][2][1]= -120; fd[6][2][2]= 988;
    fd[6][3][0]=23;fd[6][3][1]= -27;fd[6][3][2]= 955;
    fd[6][4][0]=13;fd[6][4][1]= 123;fd[6][4][2]= 918;
    fd[6][5][0]=0;fd[6][5][1]= 211;fd[6][5][2]= 864;
    fd[6][6][0]=-5;fd[6][6][1]= 297;fd[6][6][2]= 761;
    fd[6][7][0]=-13;fd[6][7][1]= 377;fd[6][7][2]= 679;
    fd[6][8][0]=-15;fd[6][8][1]= 450;fd[6][8][2]= 609;
    fd[6][9][0]=-11;fd[6][9][1]= 514;fd[6][9][2]= 549;
    fd[7][0][0]=-54;fd[7][0][1]= -72;fd[7][0][2]= 990;
    fd[7][1][0]=-54;fd[7][1][1]= -75;fd[7][1][2]= 990;
    fd[7][2][0]=-50;fd[7][2][1]= -63;fd[7][2][2]= 966;
    fd[7][3][0]=-55;fd[7][3][1]= 0;fd[7][3][2]= 937;
    fd[7][4][0]=-53;fd[7][4][1]= 151;fd[7][4][2]= 904;
    fd[7][5][0]=-63;fd[7][5][1]= 234;fd[7][5][2]= 851;
    fd[7][6][0]=-54;fd[7][6][1]= 315;fd[7][6][2]= 758;
    fd[7][7][0]=-50;fd[7][7][1]= 395;fd[7][7][2]= 671;
    fd[7][8][0]=-52;fd[7][8][1]= 459;fd[7][8][2]= 605;
    fd[7][9][0]=-43;fd[7][9][1]= 519;fd[7][9][2]= 557;
    fd[8][0][0]=36;fd[8][0][1]= -36;fd[8][0][2]= 1008;
    fd[8][1][0]=36;fd[8][1][1]= -37;fd[8][1][2]= 1004;
    fd[8][2][0]=25;fd[8][2][1]= -18;fd[8][2][2]= 952;
    fd[8][3][0]=9;fd[8][3][1]= 156;fd[8][3][2]= 864;
    fd[8][4][0]=-26;fd[8][4][1]= 264;fd[8][4][2]= 853;
    fd[8][5][0]=-21;fd[8][5][1]= 336;fd[8][5][2]= 751;
    fd[8][6][0]=-22;fd[8][6][1]= 410;fd[8][6][2]= 665;
    fd[8][7][0]=-16;fd[8][7][1]= 478;fd[8][7][2]= 591;
    fd[8][8][0]=-16;fd[8][8][1]= 540;fd[8][8][2]= 522;
    fd[8][9][0]=-18;fd[8][9][1]= 594;fd[8][9][2]= 464;
    fd[9][0][0]=18;fd[9][0][1]= 0;fd[9][0][2]= 990;
    fd[9][1][0]=14;fd[9][1][1]= -1;fd[9][1][2]= 991;
    fd[9][2][0]=7;fd[9][2][1]= 2;fd[9][2][2]= 963;
    fd[9][3][0]=-2;fd[9][3][1]= 127;fd[9][3][2]= 895;
    fd[9][4][0]=-43;fd[9][4][1]= 254;fd[9][4][2]= 852;
    fd[9][5][0]=-53; fd[9][5][1]= 336; fd[9][5][2]= 748;
    fd[9][6][0]=-49;fd[9][6][1]= 410;fd[9][6][2]= 653;
    fd[9][7][0]=-40;fd[9][7][1]= 480;fd[9][7][2]= 573;
    fd[9][8][0]=-41;fd[9][8][1]= 540;fd[9][8][2]= 503;
    fd[9][9][0]=-35;fd[9][9][1]= 594;fd[9][9][2]= 443;
    ///end of MovementA training data
    ///MovemementB training data (side up)
    int su[sample_size][sample_size][3];
    su[0][0][0]=-1008;su[0][0][1]= 72;su[0][0][2]= -36;
    su[0][1][0]=-999;su[0][1][1]= 82;su[0][1][2]= -41;
    su[0][2][0]=-990;su[0][2][1]= 99;su[0][2][2]= -44;
    su[0][3][0]=-894;su[0][3][1]= 94;su[0][3][2]= -30;
    su[0][4][0]=-815;su[0][4][1]= -131;su[0][4][2]= -61;
    su[0][5][0]=-751;su[0][5][1]= -225;su[0][5][2]= -71;
    su[0][6][0]=-665;su[0][6][1]= -297;su[0][6][2]= -78;
    su[0][7][0]=-593;su[0][7][1]= -362;su[0][7][2]= -81;
    su[0][8][0]=-530;su[0][8][1]= -421;su[0][8][2]= -89;
    su[0][9][0]=-475;su[0][9][1]= -476;su[0][9][2]= -92;
    su[1][0][0]=-990;su[1][0][1]= 90;su[1][0][2]= 18;
    su[1][1][0]=-999;su[1][1][1]= 88;su[1][1][2]= 16;
    su[1][2][0]=-998;su[1][2][1]= 88;su[1][2][2]= 5;
    su[1][3][0]=-995;su[1][3][1]= 90;su[1][3][2]= 6;
    su[1][4][0]=-884;su[1][4][1]= -21;su[1][4][2]= 12;
    su[1][5][0]=-878;su[1][5][1]= -126;su[1][5][2]= 18;
    su[1][6][0]=-793;su[1][6][1]= -210;su[1][6][2]= 16;
    su[1][7][0]=-722;su[1][7][1]= -284;su[1][7][2]= 9;
    su[1][8][0]=-664;su[1][8][1]= -354;su[1][8][2]= 2;
    su[1][9][0]=-608;su[1][9][1]= -415;su[1][9][2]= -1;
    su[2][0][0]=-1008;su[2][0][1]= 126;su[2][0][2]= 54;
    su[2][1][0]=-1009;su[2][1][1]= 126;su[2][1][2]= 48;
    su[2][2][0]=-978;su[2][2][1]= 144;su[2][2][2]= 50;
    su[2][3][0]=-889;su[2][3][1]= -10;su[2][3][2]= 46;
    su[2][4][0]=-913;su[2][4][1]= -176;su[2][4][2]= 10;
    su[2][5][0]=-805;su[2][5][1]= -257;su[2][5][2]= 3;
    su[2][6][0]=-720;su[2][6][1]= -330;su[2][6][2]= 0;
    su[2][7][0]=-646;su[2][7][1]= -394;su[2][7][2]= -5;
    su[2][8][0]=-581;su[2][8][1]= -451;su[2][8][2]= -9;
    su[2][9][0]=-524;su[2][9][1]= -503;su[2][9][2]= -13;
    su[3][0][0]=-990; su[3][0][1]= 108; su[3][0][2]= -72;
    su[3][1][0]=-988;su[3][1][1]= 109;su[3][1][2]= -81;
    su[3][2][0]=-993;su[3][2][1]= 112;su[3][2][2]= -78;
    su[3][3][0]=-938;su[3][3][1]= 126;su[3][3][2]= -70;
    su[3][4][0]=-846;su[3][4][1]= -34;su[3][4][2]= -79;
    su[3][5][0]=-835;su[3][5][1]= -144;su[3][5][2]= -89;
    su[3][6][0]=-733;su[3][6][1]= -221;su[3][6][2]= -89;
    su[3][7][0]=-666;su[3][7][1]= -299;su[3][7][2]= -92;
    su[3][8][0]=-603;su[3][8][1]= -364;su[3][8][2]= -91;
    su[3][9][0]=-548;su[3][9][1]= -423;su[3][9][2]= -90;
    su[4][0][0]=-990;su[4][0][1]= 126;su[4][0][2]= -162;
    su[4][1][0]=-991;su[4][1][1]= 126;su[4][1][2]= -162;
    su[4][2][0]=-987;su[4][2][1]= 133;su[4][2][2]= -160;
    su[4][3][0]=-893;su[4][3][1]= 114;su[4][3][2]= -126;
    su[4][4][0]=-891;su[4][4][1]= -90;su[4][4][2]= -169;
    su[4][5][0]=-805;su[4][5][1]= -180; su[4][5][2]=-171;
    su[4][6][0]=-726;su[4][6][1]= -261;su[4][6][2]= -166;
    su[4][7][0]=-658;su[4][7][1]= -333;su[4][7][2]= -162;
    su[4][8][0]=-592;su[4][8][1]= -396;su[4][8][2]= -162;
    su[4][9][0]=-534;su[4][9][1]= -453;su[4][9][2]= -160;
    su[5][0][0]=-1026;su[5][0][1]= 108;su[5][0][2]= -72;
    su[5][1][0]=-1026;su[5][1][1]= 106;su[5][1][2]= -73;
    su[5][2][0]=-988;su[5][2][1]= 122;su[5][2][2]= -67;
    su[5][3][0]=-892;su[5][3][1]= -16;su[5][3][2]= -63;
    su[5][4][0]=-901;su[5][4][1]= -136;su[5][4][2]= -69;
    su[5][5][0]=-803;su[5][5][1]= -214;su[5][5][2]= -65;
    su[5][6][0]=-729;su[5][6][1]= -289;su[5][6][2]= -67;
    su[5][7][0]=-665;su[5][7][1]= -355;su[5][7][2]= -67;
    su[5][8][0]=-605;su[5][8][1]= -416;su[5][8][2]= -74;
    su[5][9][0]=-551;su[5][9][1]= -471;su[5][9][2]= -79;
    su[6][0][0]=-990;su[6][0][1]= 108;su[6][0][2]= 18;
    su[6][1][0]=-993;su[6][1][1]= 108;su[6][1][2]= 25;
    su[6][2][0]=-989;su[6][2][1]= 109;su[6][2][2]= 15;
    su[6][3][0]=-985;su[6][3][1]= 114;su[6][3][2]= 17;
    su[6][4][0]=-882;su[6][4][1]= 46;su[6][4][2]= 27;
    su[6][5][0]=-889;su[6][5][1]= -135;su[6][5][2]= 8;
    su[6][6][0]=-789;su[6][6][1]= -213;su[6][6][2]= 10;
    su[6][7][0]=-706;su[6][7][1]= -288;su[6][7][2]= 1;
    su[6][8][0]=-633;su[6][8][1]= -360;su[6][8][2]= -6;
    su[6][9][0]=-573;su[6][9][1]= -421;su[6][9][2]= -14;
    su[7][0][0]=-1008;su[7][0][1]= 90;su[7][0][2]= -36;
    su[7][1][0]=-1006;su[7][1][1]= 95;su[7][1][2]= -41;
    su[7][2][0]=-1013;su[7][2][1]= 96;su[7][2][2]= -40;
    su[7][3][0]=-922;su[7][3][1]= 102;su[7][3][2]= -23;
    su[7][4][0]=-871;su[7][4][1]= -77;su[7][4][2]= -47;
    su[7][5][0]=-825;su[7][5][1]= -171;su[7][5][2]= -36;
    su[7][6][0]=-744;su[7][6][1]= -243;su[7][6][2]= -36;
    su[7][7][0]=-680;su[7][7][1]= -315;su[7][7][2]= -41;
    su[7][8][0]=-622;su[7][8][1]= -380;su[7][8][2]= -44;
    su[7][9][0]=-570;su[7][9][1]= -437;su[7][9][2]= -50;
    su[8][0][0]=-1008;su[8][0][1]= 72;su[8][0][2]= -72;
    su[8][1][0]=-1008;su[8][1][1]= 70;su[8][1][2]= -68;
    su[8][2][0]=-1008;su[8][2][1]= 75;su[8][2][2]= -72;
    su[8][3][0]=-901;su[8][3][1]= -9;su[8][3][2]= -52;
    su[8][4][0]=-917;su[8][4][1]= -171;su[8][4][2]= -79;
    su[8][5][0]=-816;su[8][5][1]= -243;su[8][5][2]= -83;
    su[8][6][0]=-739;su[8][6][1]= -315;su[8][6][2]= -83;
    su[8][7][0]=-666;su[8][7][1]= -378; su[8][7][2]=-87;
    su[8][8][0]=-606;su[8][8][1]= -439;su[8][8][2]= -90;
    su[8][9][0]=-550;su[8][9][1]= -490;su[8][9][2]= -90;
    su[9][0][0]=-990;su[9][0][1]= 180;su[9][0][2]= 36;
    su[9][1][0]=-991;su[9][1][1]= 180;su[9][1][2]= 32;
    su[9][2][0]=-994;su[9][2][1]= 180;su[9][2][2]= 28;
    su[9][3][0]=-997;su[9][3][1]= 185;su[9][3][2]= 27;
    su[9][4][0]=-906;su[9][4][1]= 197;su[9][4][2]= 26;
    su[9][5][0]=-853;su[9][5][1]= 8;su[9][5][2]= 3;
    su[9][6][0]=-810;su[9][6][1]= -124;su[9][6][2]= -15;
    su[9][7][0]=-705;su[9][7][1]= -203;su[9][7][2]= -31;
    su[9][8][0]=-616;su[9][8][1]= -279;su[9][8][2]= -45;
    su[9][9][0]=-540;su[9][9][1]= -344;su[9][9][2]= -58;
    ///end of MovementB training data
    ///MovemementC training data (face up)
    int fu[sample_size][sample_size][3];
	   fu[0][0][0]=90; fu[0][0][1]= -36; fu[0][0][2]= -990;
	   fu[0][1][0]=88; fu[0][1][1]= -36; fu[0][1][2]= -990;
	   fu[0][2][0]=82; fu[0][2][1]= -39; fu[0][2][2]= -988;
	   fu[0][3][0]= 81; fu[0][3][1]=-42; fu[0][3][2]= -984;
	  fu[0][4][0]=  87; fu[0][4][1]=-3; fu[0][4][2]= -918;
	  fu[0][5][0]= 63; fu[0][5][1]=191; fu[0][5][2]= -883;
	  fu[0][6][0]=  63; fu[0][6][1]=278; fu[0][6][2]= -818;
	  fu[0][7][0]=  63; fu[0][7][1]=354; fu[0][7][2]= -725;
	   fu[0][8][0]= 54; fu[0][8][1]=421; fu[0][8][2]= -652;
	fu[0][9][0]=  55; fu[0][9][1]=486; fu[0][9][2]= -583;
	 fu[1][0][0]=   0; fu[1][0][1]=36; fu[1][0][2]= -954;
	  fu[1][1][0]=  3; fu[1][1][1]=37; fu[1][1][2]= -964;
	  fu[1][2][0]=  6; fu[1][2][1]=36; fu[1][2][2]= -973;
	  fu[1][3][0]=  14; fu[1][3][1]=59; fu[1][3][2]= -913;
	   fu[1][4][0]= 28; fu[1][4][1]=222; fu[1][4][2]= -855;
	   fu[1][5][0]= 28; fu[1][5][1]=325; fu[1][5][2]= -830;
	   fu[1][6][0]= 32; fu[1][6][1]=396; fu[1][6][2]= -734;
	   fu[1][7][0]= 19; fu[1][7][1]=462; fu[1][7][2]= -648;
	   fu[1][8][0]= 17; fu[1][8][1]=522; fu[1][8][2]= -570;
	   fu[1][9][0]= 11; fu[1][9][1]=577; fu[1][9][2]= -498;
	 fu[2][0][0]=   54; fu[2][0][1]=18; fu[2][0][2]= -990;
	  fu[2][1][0]=  52; fu[2][1][1]=10; fu[2][1][2]= -997;
	  fu[2][2][0]=  52; fu[2][2][1]= -3; fu[2][2][2]= -971;
	  fu[2][3][0]=  57; fu[2][3][1]=126;fu[2][3][2]=  -897;
	  fu[2][4][0]=  58; fu[2][4][1]=284; fu[2][4][2]= -875;
	  fu[2][5][0]=  68; fu[2][5][1]=360; fu[2][5][2]= -776;
	  fu[2][6][0]=  68; fu[2][6][1]=430; fu[2][6][2]= -687;
	  fu[2][7][0]=  63; fu[2][7][1]=500; fu[2][7][2]= -602;
	  fu[2][8][0]=  62; fu[2][8][1]=552; fu[2][8][2]= -536;
	  fu[2][9][0]=  52; fu[2][9][1]=603; fu[2][9][2]= -466;
	 fu[3][0][0]=   90; fu[3][0][1]=0; fu[3][0][2]= -990;
	fu[3][1][0]=   88; fu[3][1][1]=-3; fu[3][1][2]= -986;
	  fu[3][2][0]=  88; fu[3][2][1]=0; fu[3][2][2]= -986;
	  fu[3][3][0]=  90; fu[3][3][1]=-5; fu[3][3][2]= -934;
	  fu[3][4][0]=  102; fu[3][4][1]=110; fu[3][4][2]= -880;
	   fu[3][5][0]= 109; fu[3][5][1]=266; fu[3][5][2]= -867;
	  fu[3][6][0]=  103; fu[3][6][1]=343; fu[3][6][2]= -764;
	  fu[3][7][0]=  101; fu[3][7][1]=409; fu[3][7][2]= -664;
	  fu[3][8][0]=  98; fu[3][8][1]=476; fu[3][8][2]= -585;
	fu[3][9][0]=   91; fu[3][9][1]=538; fu[3][9][2]= -508;
	 fu[4][0][0]=   90; fu[4][0][1]=-72; fu[4][0][2]= -990;
	fu[4][1][0]=   95; fu[4][1][1]=-70; fu[4][1][2]= -991;
	 fu[4][2][0]=   94; fu[4][2][1]=-57; fu[4][2][2]= -987;
	fu[4][3][0]=   93; fu[4][3][1]=0; fu[4][3][2]= -931;
	 fu[4][4][0]=   94; fu[4][4][1]=189; fu[4][4][2]= -870;
	fu[4][5][0]=   97; fu[4][5][1]=279; fu[4][5][2]= -788;
	 fu[4][6][0]=   89; fu[4][6][1]=355; fu[4][6][2]= -682;
	fu[4][7][0]=   87; fu[4][7][1]=427; fu[4][7][2]= -595;
	 fu[4][8][0]=   80; fu[4][8][1]=488; fu[4][8][2]= -517;
	fu[4][9][0]=   79; fu[4][9][1]=545; fu[4][9][2]= -449;
	 fu[5][0][0]=   126; fu[5][0][1]=-36; fu[5][0][2]= -1008;
	fu[5][1][0]=   118; fu[5][1][1]=-34; fu[5][1][2]= -1008;
	 fu[5][2][0]=   106; fu[5][2][1]=-36; fu[5][2][2]= -1004;
	  fu[5][3][0]=  106; fu[5][3][1]=-37; fu[5][3][2]= -946;
	  fu[5][4][0]=  113; fu[5][4][1]=134; fu[5][4][2]= -874;
	fu[5][5][0]=   121; fu[5][5][1]=252; fu[5][5][2]= -855;
	 fu[5][6][0]=   123; fu[5][6][1]=334; fu[5][6][2]= -744;
	fu[5][7][0]=   116; fu[5][7][1]=406; fu[5][7][2]= -651;
	 fu[5][8][0]=   109; fu[5][8][1]=473; fu[5][8][2]= -562;
	fu[5][9][0]=   101; fu[5][9][1]=530; fu[5][9][2]= -487;
	 fu[6][0][0]=   90; fu[6][0][1]=18; fu[6][0][2]= -972;
	fu[6][1][0]=   91; fu[6][1][1]=18; fu[6][1][2]= -973;
	 fu[6][2][0]=   94; fu[6][2][1]=21; fu[6][2][2]= -972;
	fu[6][3][0]=    90; fu[6][3][1]=42; fu[6][3][2]= -910;
	fu[6][4][0]=    82; fu[6][4][1]=178; fu[6][4][2]= -869;
	fu[6][5][0]=   99; fu[6][5][1]=298; fu[6][5][2]= -843;
	 fu[6][6][0]=   94; fu[6][6][1]=372; fu[6][6][2]= -737;
	fu[6][7][0]=    93; fu[6][7][1]=444; fu[6][7][2]= -654;
	 fu[6][8][0]=   89; fu[6][8][1]=507; fu[6][8][2]= -574;
	  fu[6][9][0]=  89; fu[6][9][1]=562; fu[6][9][2]= -504;
	 fu[7][0][0]=   18; fu[7][0][1]=18; fu[7][0][2]= -1026;
	fu[7][1][0]=    21; fu[7][1][1]=19; fu[7][1][2]= -1026;
	fu[7][2][0]=    26; fu[7][2][1]=6; fu[7][2][2]= -1006;
	fu[7][3][0]=    32; fu[7][3][1]=73; fu[7][3][2]= -959;
	 fu[7][4][0]=   36; fu[7][4][1]=233; fu[7][4][2]= -861;
	fu[7][5][0]=   48; fu[7][5][1]=319; fu[7][5][2]= -816;
	 fu[7][6][0]=   54; fu[7][6][1]=396; fu[7][6][2]= -703;
	fu[7][7][0]=   55; fu[7][7][1]=460; fu[7][7][2]= -614;
	 fu[7][8][0]=   54; fu[7][8][1]=520; fu[7][8][2]= -532;
	fu[7][9][0]=   54; fu[7][9][1]=572; fu[7][9][2]= -462;
	fu[8][0][0]=    54; fu[8][0][1]=36; fu[8][0][2]= -1026;
	   fu[8][1][0]= 54; fu[8][1][1]=34; fu[8][1][2]= -1029;
	  fu[8][2][0]=  54; fu[8][2][1]=14; fu[8][2][2]= -1012;
	  fu[8][3][0]=  61; fu[8][3][1]=144; fu[8][3][2]= -914;
	 fu[8][4][0]=   80; fu[8][4][1]=300; fu[8][4][2]= -889;
	  fu[8][5][0]=  82; fu[8][5][1]=376; fu[8][5][2]= -780;
	  fu[8][6][0]=  82; fu[8][6][1]=442; fu[8][6][2]= -673;
	  fu[8][7][0]=  84; fu[8][7][1]=507; fu[8][7][2]= -576;
	  fu[8][8][0]=  82; fu[8][8][1]=560; fu[8][8][2]= -491;
	fu[8][9][0]=   82; fu[8][9][1]=608; fu[8][9][2]= -418;
	 fu[9][0][0]=   72; fu[9][0][1]=-36; fu[9][0][2]= -1044;
	fu[9][1][0]=    75; fu[9][1][1]=-28; fu[9][1][2]= -1036;
	fu[9][2][0]=    81; fu[9][2][1]=-28; fu[9][2][2]= -1038;
	fu[9][3][0]=    81; fu[9][3][1]=23; fu[9][3][2]= -910;
	fu[9][4][0]=    85; fu[9][4][1]=238; fu[9][4][2]= -865;
	fu[9][5][0]=    94; fu[9][5][1]=315; fu[9][5][2]= -771;
	 fu[9][6][0]=   90; fu[9][6][1]=387; fu[9][6][2]= -659;
	fu[9][7][0]=   88; fu[9][7][1]=449; fu[9][7][2]= -580;
	 fu[9][8][0]=   86; fu[9][8][1]=512; fu[9][8][2]= -500;
	fu[9][9][0]=   84; fu[9][9][1]=567; fu[9][9][2]= -430;
    ///end of MovementC training data
    int tempA[BUFFER_SIZE];
    int tempB[BUFFER_SIZE];
    int tempC[BUFFER_SIZE];
    int diffArray[3][BUFFER_SIZE];
    int i,j, temp;
    for (i=0;i<3;i++){
    	for (j=0;j<BUFFER_SIZE;j++){
    		diffArray[i][j] = 0;
    		tempA[j] = 0;
    		tempB[j] = 0;
    		tempC[j] = 0;
    	}
    }

 ///K nearest neighbour 
    ///calculating the distance between current buffer and training data
    for (i=0;i<sample_size;i++){
        //comparing training data
        for (j=0;j<BUFFER_SIZE;j++){
            ///calculating distance (training sample i)
            tempA[j] = distance(motionBuffer[j],fd[i][j]); //vs MovementA
            tempB[j] = distance(motionBuffer[j],su[i][j]);  //vs MovementB
            tempC[j] = distance(motionBuffer[j],fu[i][j]);  //vs MovementC
        }
        temp = metro(tempA);
        diffArray[0][i] = temp;
        temp = metro(tempB);
        diffArray[1][i] = temp;
        temp = metro(tempC);
        diffArray[2][i] = temp;
    }
    //diffArray contains all data that we need to sort out
    //lets check our best candidates
    qsort(diffArray[0],sample_size,sizeof(int),sort1);
    qsort(diffArray[1],sample_size,sizeof(int),sort1);
    qsort(diffArray[2],sample_size,sizeof(int),sort1);
    int finalSort[k_nearest];
    //lets find the lowest values
    int kk = 0;
    int i1 = 0;
    int j1 = 0;
    int k1 = 0;
    while (kk<k_nearest){
        if ((diffArray[0][i1] <= diffArray[1][j1]) && (diffArray[0][i1] <= diffArray[2][k1])){
            finalSort[kk] = 0;
            i1++;
        }else if ((diffArray[1][j1] <= diffArray[0][i1]) && (diffArray[1][j1] < diffArray[2][k1])){
            finalSort[kk] = 1;
            j1++;
        }else if ((diffArray[2][k1] < diffArray[0][i1]) && (diffArray[2][k1] < diffArray[1][j1])){
            finalSort[kk] = 2;
            k1++;
        }
        kk++;
    }
    ///final voting
    g_print("Voting Array: %i %i %i %i %i\n",finalSort[0],finalSort[1],finalSort[2],finalSort[3],finalSort[4]);
    g_print("Smallest Values: ( %i %i )( %i %i )( %i %i )\n",diffArray[0][0],diffArray[0][1],diffArray[1][0],diffArray[1][1],diffArray[2][0],diffArray[2][1]);
    int voteA = 0;
    int voteB = 0;
    int voteC = 0;
    for (i=0;i<k_nearest;i++){
        if (finalSort[i] == 0){
            voteA++;
        }else if (finalSort[i] == 1){
            voteB++;
        }else if (finalSort[i] == 2){
            voteC++;
        }
    }
    int result = -1;
    if (voteA >= voteB && voteA >= voteC){
        result = 0;
        g_print("Possible Movement A (face down)\n");
    }else if (voteB > voteA && voteB > voteC){
        result = 1;
        g_print("Possible Movement B (side up)\n");
    }else if (voteC > voteA && voteC > voteB){
        result = 2;
        g_print("Possible Movement C (face up)\n");
    }
    if (firsttime == 1){
        create_emma_int(result);
    }
    if (diffArray[result][0] < e){
        g_print("Movement %i\n", result);
  	//  printf("soundKit:%s\n", soundKit);
        playSound(result);
    }
   return 0;
}

static gboolean on_roller_button_press_up (ClutterActor *rect, ClutterEvent *event, gpointer data){
	if (selectedKitNum < 7){
		setSoundKitNum (selectedKitNum+1);
		g_print(">>>>>>>>>>selectedKit: %s, selectedKitNum, %i\n",instr[selectedKitNum].folder, selectedKitNum );
	}
	
	return TRUE;
}

static gboolean on_roller_button_press_down (ClutterActor *rect, ClutterEvent *event, gpointer data){
	if (selectedKitNum > 0){
		setSoundKitNum (selectedKitNum - 1);
		g_print(">>>>>>>>>>selectedKit: %s, selectedKitNum, %i\n",instr[selectedKitNum].folder, selectedKitNum );
	}
	return TRUE;
}

///destroy function
void jammer_gohome_button (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	g_print("Jammer go home!\n");
	g_source_remove(loop_id);
	g_object_unref(G_OBJECT(jammerSample0));
	g_object_unref(G_OBJECT(jammerSample1));
	g_object_unref(G_OBJECT(jammerSample2));
	clutter_actor_hide(jammo_get_actor_by_id("jammer-view"));
	clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));
}

///mentor function
void jammer_press_mentor (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	g_print("Jammer Mentor!\n");
}

void jammer_press_play (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	g_print("Jammer play!\n");
	isJammerRecording = FALSE;
	isJammerPlaying = FALSE;
	jammo_sequencer_stop(jammer_sequencer);
	jammo_sequencer_play(jammer_sequencer);
}

/*RECORD*/
void jammer_press_rec (TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	if (!isJammerRecording){
	//start recording	
		isJammerRecording = TRUE;
		jammo_sequencer_play (JAMMO_SEQUENCER (jammer_sequencer));
		tangle_button_set_selected(TANGLE_BUTTON(jammo_get_actor_by_id("jammer_rec_button")),TRUE);
	}else{
	//stop recording
		isJammerRecording = FALSE;
		jammo_sequencer_stop(jammer_sequencer);
		tangle_button_set_selected(TANGLE_BUTTON(jammo_get_actor_by_id("jammer_rec_button")),FALSE);
	}
	
}

static gboolean timeout_func(gpointer data){ ///this runs at jammerFreq (in millisecs)
	jammerCounter++;
	if (isJammerPlaying){	
		int j = 0;
		int x = 0;
		int y = 0;
		int z = 0;
		int SENSITIVITY = 350; ///how sensitive jammer is TODO: adjust it to current sound latency
		int accel_test;	
		accel_test = accel_read(&x, &y, &z);	
		if (accel_test != 0){
			//g_print ("No accelerometer present\n");
		}
		if (jammerCounter<=BUFFER_SIZE){
			motionBuffer[BUFFER_SIZE-jammerCounter][0]  =  x;
			motionBuffer[BUFFER_SIZE-jammerCounter][1]  =  y;
			motionBuffer[BUFFER_SIZE-jammerCounter][2]  =  z;
		}else{
			for (j=BUFFER_SIZE-1;j>0;j--){
				motionBuffer[j][0] = motionBuffer[j-1][0];
				motionBuffer[j][1] = motionBuffer[j-1][1];
				motionBuffer[j][2] = motionBuffer[j-1][2];
			}
			motionBuffer[0][0]  =  x;
			motionBuffer[0][1]  =  y;
			motionBuffer[0][2]  =  z;
		}
		///build EMMA file (alex #1)
		if (jammerCounter == BUFFER_SIZE){
			 create_emma(motionBuffer);
		}
		///calculate results every 1.5 seconds //todo: adjust this
		if (jammerCounter%6 == 0){	
			if (jammerCounter == 6){
				motion_detect(SENSITIVITY, 1);
			}else{
				motion_detect(SENSITIVITY, 1);
			}
		}
	}		      
	return TRUE;
}
////INITIALISE JAMMER INSTRUMENTS
static void init_jammerinstr(ClutterActor *btnSet){
	//instruments init
	instr[0].id = 0;
	g_strlcpy(instr[0].avatarfile, "jammer_electric.png", 25);
	g_strlcpy(instr[0].folder, "elec", 5);	
	instr[0].isMelodic = FALSE;	
	instr[1].id = 1;
	g_strlcpy(instr[1].avatarfile, "jammer_ethnic.png", 25);
	g_strlcpy(instr[1].folder, "eth1", 5);
	instr[1].isMelodic = FALSE;	
	instr[2].id = 2;
	g_strlcpy(instr[2].avatarfile, "jammer_ethnic2.png", 25);
	g_strlcpy(instr[2].folder, "eth2", 5);
	instr[2].isMelodic = FALSE;	
	instr[3].id = 3;
	g_strlcpy(instr[3].avatarfile, "jammer_acoustic.png", 25);
	g_strlcpy(instr[3].folder, "popk", 5);
	instr[3].isMelodic = FALSE;
	instr[4].id = 4;
	g_strlcpy(instr[4].avatarfile, "jammer_glockenspiel.png", 25);
	g_strlcpy(instr[4].folder, "gloc", 5);	
	instr[4].isMelodic = TRUE;
	instr[5].id = 5;
	g_strlcpy(instr[5].avatarfile, "jammer_marimba.png", 25);
	g_strlcpy(instr[5].folder, "mari", 5);	
	instr[5].isMelodic = TRUE;
	instr[6].id = 6;
	g_strlcpy(instr[6].avatarfile, "jammer_oud.png", 25);
	g_strlcpy(instr[6].folder, "oudi", 5);	
	instr[6].isMelodic = TRUE;
	instr[7].id = 7;
	g_strlcpy(instr[7].avatarfile, "jammer_xylophone.png", 25);
	g_strlcpy(instr[7].folder, "xylo", 5);	
	instr[7].isMelodic = TRUE;
	//init images
	int posx = 0;
	int i;
	for (i=0;i<8;i++){
		instr[i].instrumentImg = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, instr[i].avatarfile, NULL), NULL);
		clutter_actor_set_size (instr[i].instrumentImg, 90, 90);
		clutter_actor_set_position (instr[i].instrumentImg, posx,25);
		clutter_container_add_actor (CLUTTER_CONTAINER (btnSet),instr[i].instrumentImg);
		clutter_actor_set_reactive (instr[i].instrumentImg, TRUE);
		posx = posx + 120;
	}
	
}

static int findNextSlot(){
	if (melodicSounds[0] == NULL){
		return 0;
	}else if (melodicSounds[1] == NULL){
		return 1;
	}else if (melodicSounds[2] == NULL){
		return 2;
	}
	return -1;
}

static int getKeyPos(ClutterActor *key, gboolean isBlack){
	gfloat x = 0.0;
	gfloat y = 0.0;
	clutter_actor_get_position(key, &x, &y);
//initial 0: rest 1,2,3
	if (isBlack){
		if (y == -150.0){
			return 0;
		}else{
			return -y/50+1;
		}
	}else{
		if (y == -204.0){
			return 0;
		}else{
			return -y/68+1;
		}
	}
}


static void setKeyPos(ClutterActor *key, int pos, gboolean isBlack){
	gfloat x = 0.0;
	gfloat y = 0.0;	
	clutter_actor_get_position(key, &x, &y);
	if (isBlack){
		if (pos == 0){
			y = -150;
		}else{
			y = -150+(pos)*50;
		}
	}else{
		if (pos == 0){
			y = -204;
		}else{
			y = -204+(pos)*68;
		}
	}
	clutter_actor_set_position(key, 0, y);
}

/*sets a melodic sound*/

static int setMelodicSound(ClutterActor *key){
	int i;	
	const gchar *keyName = clutter_actor_get_name(key);
	nextmelodicSoundsIndex = findNextSlot();
	i = melodicSoundsIndex;		
	melodicSounds[nextmelodicSoundsIndex] = keyName;		
	melodicSoundsIndex++;
	nextmelodicSoundsIndex++;
	if (melodicSoundsIndex == 3){
		setSoundKit(); //init all instruments	
	}
	//g_print("set:%s -- %s -- %s -- %i\n",melodicSounds[0],melodicSounds[1],melodicSounds[2], i );
	return i;
}

/*unsets a melodic sound*/
/*inputs: key ClutterActor and sound index position*/
static void unsetMelodicSound(ClutterActor *key, int i){
	melodicSounds[i-1] = NULL;
	nextmelodicSoundsIndex = i-1;
	melodicSoundsIndex--;
	//g_print("unset:%s -- %s -- %s -- %i\n",melodicSounds[0],melodicSounds[1],melodicSounds[2], i );
}

/*note preview*/

static void preview_note(ClutterActor *key){
	JammoSample* previewSample;
	const gchar *keyName = clutter_actor_get_name(key);
	char *file;
	file = g_strdup_printf("%s%s/%s_%s.ogg", JAMMERSOUNDPATH,instr[selectedKitNum].folder, instr[selectedKitNum].folder,keyName);
	previewSample = jammo_sample_new_from_file_with_sequencer(file, jammer_sequencer);
}

/*play a white key*/

static gboolean white_key_pressed (ClutterActor *rect, ClutterEvent *event, gpointer data){
	int pos;
	int i;
	ClutterActor *parentActor;
	parentActor = clutter_actor_get_parent(rect);
	pos = getKeyPos(rect, FALSE);	

	if (pos == 0 && melodicSoundsIndex != 3){
		preview_note(parentActor);
		i = setMelodicSound(parentActor);
		i = i +1;
		//key is white and we can set a sound
		setKeyPos(rect, i, FALSE);
	}else if (pos != 0){
		//key has already a sound on and we need to unset it
		unsetMelodicSound(parentActor, pos);
		setKeyPos(rect, 0, FALSE);
	}
	return FALSE;
}


/*play a black key*/

static gboolean black_key_pressed (ClutterActor *rect, ClutterEvent *event, gpointer data){
	int i;
	int pos;
	pos = getKeyPos(rect, TRUE);	
	ClutterActor *parentActor;
	parentActor = clutter_actor_get_parent(rect);
	if (pos == 0 && melodicSoundsIndex != 3){
		preview_note(parentActor);
		i = setMelodicSound(parentActor);
		i = i + 1;
		//key is white and we can set a sound
		setKeyPos(rect, i, TRUE);
	}else if (pos != 0){
		//key has already a sound on and we need to unset it
		unsetMelodicSound(parentActor, pos);
		setKeyPos(rect, 0, TRUE);
	}
	return FALSE;	
}


/* builds octaves*/
static void create_octave(ClutterActor *octSet, gchar *octavenum){
	///notes order (builds from top)
	///b, a, g, f, e, d, c
	int i;
	int posy = 0;
	//white keys	
	for (i=0;i<7;i++){
		ClutterActor *whiteKey_container[i];
		whiteKey_container[i] = clutter_group_new();
		clutter_actor_set_size (whiteKey_container[i], 77, 68);
		clutter_actor_set_position (whiteKey_container[i], 0, posy);
		clutter_container_add_actor (CLUTTER_CONTAINER (octSet), whiteKey_container[i]);
		clutter_actor_set_reactive (whiteKey_container[i], TRUE);
		clutter_actor_set_clip_to_allocation (whiteKey_container[i], TRUE);
		///TODO: Doing it fast instead of elegant ... fix this
		if (i == 0){	
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "b",octavenum, NULL));
		}else if (i == 1){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "a",octavenum, NULL));
		}else if (i == 2){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "g",octavenum, NULL));
		}else if (i == 3){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "f",octavenum, NULL));
		}else if (i == 4){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "e",octavenum, NULL));
		}else if (i == 5){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "d",octavenum, NULL));
		}else if (i == 6){
			clutter_actor_set_name(whiteKey_container[i], g_strconcat( "c",octavenum, NULL));
		}
		//////TEXTURE FILE
		ClutterActor *octSet1_whiteKeysTexture;
		octSet1_whiteKeysTexture = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_key_white-withbg.png", NULL), NULL);
		clutter_actor_set_size (octSet1_whiteKeysTexture,77, 272);
		clutter_actor_set_position (octSet1_whiteKeysTexture, 0, -204);
		clutter_container_add_actor (CLUTTER_CONTAINER (whiteKey_container[i]), octSet1_whiteKeysTexture);
		clutter_actor_set_reactive (octSet1_whiteKeysTexture, TRUE);
		g_signal_connect (octSet1_whiteKeysTexture, "button-press-event", G_CALLBACK (white_key_pressed), NULL);
		posy = posy + 68;
	}
	//black keys -- skips iteration #3
	posy = 40;
	for (i=0;i<6;i++){
		ClutterActor *blackKey_container[i];
		if (i != 3){
			blackKey_container[i] = clutter_group_new();
			clutter_actor_set_size (blackKey_container[i], 46, 50);
			clutter_actor_set_position (blackKey_container[i], 0, posy);
			clutter_container_add_actor (CLUTTER_CONTAINER (octSet), blackKey_container[i]);
			clutter_actor_set_reactive (blackKey_container[i], TRUE);
			clutter_actor_set_clip_to_allocation (blackKey_container[i], TRUE);
			///TODO: Doing it fast instead of elegant ... fix this
			if (i == 0){	
				clutter_actor_set_name(blackKey_container[i], g_strconcat( "a#",octavenum, NULL));
			}else if (i == 1){
				clutter_actor_set_name(blackKey_container[i], g_strconcat( "g#",octavenum, NULL));
			}else if (i == 2){
				clutter_actor_set_name(blackKey_container[i], g_strconcat( "f#",octavenum, NULL));
			}else if (i == 4){
				clutter_actor_set_name(blackKey_container[i], g_strconcat( "d#",octavenum, NULL));
			}else if (i == 5){
				clutter_actor_set_name(blackKey_container[i], g_strconcat( "c#",octavenum, NULL));
			}
					
			//////TEXTURE FILE
			ClutterActor *octSet1_blackKeysTexture;
			octSet1_blackKeysTexture = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_key_black-withbg.png", NULL), NULL);
			clutter_actor_set_size (octSet1_blackKeysTexture,43, 200);
			clutter_actor_set_position (octSet1_blackKeysTexture, 0, -150);
			clutter_container_add_actor (CLUTTER_CONTAINER (blackKey_container[i]), octSet1_blackKeysTexture);
			clutter_actor_set_reactive (octSet1_blackKeysTexture, TRUE);
			g_signal_connect (octSet1_blackKeysTexture, "button-press-event", G_CALLBACK (black_key_pressed), NULL);
		}
		posy = posy + 70;
	}
}

void 
start_jammer ()
{
	//init clutter
	ClutterActor *stage;
	stage = tangle_widget_new(); //TODO: define this and all other (clutter_texture_new_from_file) on jammer-view.json! --moved some to json

	//init jammer
	g_print("starting jammer\n");
	isJammerPlaying = TRUE;
	isJammerRecording = FALSE;
	jammer_sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	jammer_editing_track = jammo_editing_track_new(); 
	jammo_sequencer_add_track (jammer_sequencer, JAMMO_TRACK (jammer_editing_track));
	guint jammerFreq = 250; ///how often jammer reads values and calcs TODO: adjust it to current sound latency

	/*Roller group (btnSet2)*/
	ClutterActor *btnSet2 = clutter_group_new();
	clutter_actor_set_size (btnSet2, 200, 280);
	clutter_actor_set_position (btnSet2, 140, 100);
	clutter_container_add_actor (CLUTTER_CONTAINER (stage), btnSet2);
	clutter_actor_set_reactive (btnSet2, TRUE);
	/*Up button right*/
	ClutterActor *upBtn1 = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_arrows_up.png", NULL), NULL);
	clutter_actor_set_size (upBtn1, 84, 23);
	clutter_actor_set_position (upBtn1, 0,0);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet2),upBtn1);
	g_signal_connect (upBtn1, "button-press-event", G_CALLBACK (on_roller_button_press_up), NULL);
	clutter_actor_set_reactive (upBtn1, TRUE);
	/*Up button left*/
	ClutterActor *upBtn2 = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_arrows_up.png", NULL), NULL);
	clutter_actor_set_size (upBtn2, 84, 23);
	clutter_actor_set_position (upBtn2, 0,260);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet2),upBtn2);
	g_signal_connect (upBtn2, "button-press-event", G_CALLBACK (on_roller_button_press_up), NULL);
	clutter_actor_set_reactive (upBtn2, TRUE);
	/*Down button right*/
	ClutterActor *downBtn1 = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_arrows_down.png", NULL), NULL);
	clutter_actor_set_size (downBtn1, 84, 23);
	clutter_actor_set_position (downBtn1, 120,0);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet2),downBtn1);
	g_signal_connect (downBtn1, "button-press-event", G_CALLBACK (on_roller_button_press_down), NULL);
	clutter_actor_set_reactive (downBtn1, TRUE);
	/*Down button left*/
	ClutterActor *downBtn2 = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "jammer_arrows_down.png", NULL), NULL);
	clutter_actor_set_size (downBtn2, 84, 23);
	clutter_actor_set_position (downBtn2, 120,260);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet2),downBtn2);
	g_signal_connect (downBtn2, "button-press-event", G_CALLBACK (on_roller_button_press_down), NULL);
	clutter_actor_set_reactive (downBtn2, TRUE);
	/*End of button group btnSet2*/
	/*Start of button group for instruments  btnSet3*/
	ClutterActor *viewpoint3 = clutter_group_new();
	clutter_actor_set_size (viewpoint3, 350, 140);
	clutter_actor_set_position (viewpoint3, 60, 170);
	clutter_container_add_actor (CLUTTER_CONTAINER (stage), viewpoint3);
	clutter_actor_set_reactive (viewpoint3, FALSE);
	clutter_actor_set_clip_to_allocation (viewpoint3, TRUE);	
	btnSet3 = clutter_group_new();
	clutter_actor_set_size (btnSet3, 1000, 140);
	clutter_actor_set_position (btnSet3,15, 0);
	clutter_container_add_actor (CLUTTER_CONTAINER (viewpoint3), btnSet3);
	clutter_actor_set_reactive (btnSet3, FALSE);
	/*instrument positions*/
	init_jammerinstr(btnSet3);
	//init kits
	setSoundKit();
	/*gui element*/
	ClutterActor *chosenBtn = clutter_texture_new_from_file(g_build_filename(JAMMERIMGPATH, "chosen.png", NULL), NULL);
	clutter_actor_set_size (chosenBtn, 130, 130);
	clutter_actor_set_position (chosenBtn, 115,5);
	clutter_container_add_actor (CLUTTER_CONTAINER (viewpoint3),chosenBtn);
	clutter_actor_set_reactive (downBtn2, FALSE);
	/*End of button group btnSet3*/
	/*Build octaves for melodic instruments (btnSet3)*/
	btnSet4 = clutter_group_new();
	clutter_actor_set_size (btnSet4, 240, 480);
	clutter_actor_set_position (btnSet4, 570, 3);
	clutter_container_add_actor (CLUTTER_CONTAINER (stage), btnSet4);
	clutter_actor_set_reactive (btnSet4, FALSE);
	/* Top octave */
	ClutterActor *octSet1 = clutter_group_new();
	clutter_actor_set_size (octSet1,77, 460);
	clutter_actor_set_position (octSet1, 0, 0);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet4), octSet1);
	clutter_actor_set_reactive (octSet1, FALSE);
	create_octave(octSet1, "1");
	/*middle octave*/
	ClutterActor *octSet2 = clutter_group_new();
	clutter_actor_set_size (octSet2,77, 480);
	clutter_actor_set_position (octSet2, 77, 0);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet4), octSet2);
	clutter_actor_set_reactive (octSet2, FALSE);
	create_octave(octSet2, "2");		
	/*bottom octave*/
	ClutterActor *octSet3 = clutter_group_new();
	clutter_actor_set_size (octSet3,77, 480);
	clutter_actor_set_position (octSet3, 154, 0);
	clutter_container_add_actor (CLUTTER_CONTAINER (btnSet4), octSet3);
	clutter_actor_set_reactive (octSet3, FALSE);
	create_octave(octSet3, "3");
	/*hide piano*/
	clutter_actor_hide_all(btnSet4);
	/*End of button group btnSet4*/
	//////setting up jammer vars
	g_print("motionBuffer starting\n");
	int i, j;	
	for (i=0;i < BUFFER_SIZE; i++){
		for (j=0;j<3;j++){
			motionBuffer[i][j] = 0;
		}
	}
	///
	g_print("loop starting\n");
 	loop_id = g_timeout_add(jammerFreq,timeout_func, NULL); 
	g_print("show jammer\n");
	clutter_actor_show(stage);
	tangle_widget_add(TANGLE_WIDGET(jammo_get_actor_by_id("jammer-view")),stage,NULL);
}
