/*
There are list of songs.
When pressing song-icon it will start playing alone ( on ad-hoc sequencer).
 Pressing another song-icon will stop previous song.

If vocal-button is toggled, vocal-version of track is used.


Last selected/listened will be used when user press 'OK'-button.
Cancel-button returns without modification.

*/
#include <glib-object.h>
#include <tangle.h>


#include "../../meam/jammo-meam.h"
#include "../../meam/jammo-backing-track.h"


#include "../jammo.h"
#include "../../configure.h"
#include "../save_helper.h"
#include "sequencer.h"

//This affects to adhoc_sequencer and when returning to main-view.
static gboolean vocal_selected = FALSE;
static gchar* last_played_filename=NULL;

static JammoSequencer* adhoc_sequencer=NULL;
static void on_sequencer_stopped(JammoSequencer* sequencer, gpointer user_data) {
	printf("backingtrack_selection.c: on_sequencer_stopped\n");
	g_object_unref(sequencer);
	adhoc_sequencer=NULL;
}


void backingtrack_song_clicked (TangleButton* tanglebutton, gpointer none){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(tanglebutton));
	printf("backingtrack_song_clicked: '%s'\n",name);

	//Vocal or accompaniment only
	gchar* prefix = vocal_selected?"SaV":"Sa";


	gchar* backing_track_filename = g_strdup_printf("%s/backingtracks/%s_%s_$t_$p.ogg",DATA_DIR,prefix,name);
	printf ("looking backing_track_filename: '%s'\n",backing_track_filename);
	if (adhoc_sequencer){
		jammo_sequencer_stop(adhoc_sequencer);
	}

	adhoc_sequencer = jammo_sequencer_new();
	JammoSequencer* global_sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	jammo_sequencer_set_tempo(adhoc_sequencer,jammo_sequencer_get_tempo(global_sequencer));
	jammo_sequencer_set_pitch(adhoc_sequencer,jammo_sequencer_get_pitch(global_sequencer));
	//printf("tempo and pitch set\n");

	JammoTrack* track = JAMMO_TRACK(jammo_backing_track_new(backing_track_filename));
	jammo_sequencer_add_track(adhoc_sequencer, JAMMO_TRACK(track));
	if (last_played_filename)
		g_free(last_played_filename);
	last_played_filename = g_strdup_printf("%s",backing_track_filename);

	g_signal_connect(adhoc_sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), NULL);
	jammo_sequencer_play(adhoc_sequencer);
}


void backingtrack_selection_vocal_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_vocal_clicked\n");
	vocal_selected = tangle_button_get_selected(tanglebutton);
}

static void end_backingtrack_selection() {
	if (adhoc_sequencer) {
		jammo_sequencer_stop(adhoc_sequencer);
		g_object_unref(adhoc_sequencer);
		adhoc_sequencer=NULL;
	}

	if (last_played_filename) {
		g_free(last_played_filename);
		last_played_filename=NULL;
	}
	clutter_actor_hide(jammo_get_actor_by_id("backingtrack-selection-view"));
	clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));
}


void backingtrack_selection_ok_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_ok_clicked\n");

	if (last_played_filename) {
	JammoSequencer* sequencer = JAMMO_SEQUENCER(jammo_get_object_by_id("fullsequencer-the-sequencer"));
	gint track_count = jammo_sequencer_get_track_count(sequencer);

	JammoTrack* track;
	int i;
	for (i=0;i<track_count;i++) {
	 track = jammo_sequencer_get_track(sequencer, i);
		if (JAMMO_IS_BACKING_TRACK(track)){
			printf ("found\n");
				gchar* meta_data = g_strdup_printf
				("\"pitch\" : \"%s\",\n\"tempo\" : %d,\n",jammo_sequencer_get_pitch(sequencer),jammo_sequencer_get_tempo(sequencer));
				gchar* filename = save_composition("7-12/temp_", jammo_get_actor_by_id("fullsequencer-container-for-tracks"), meta_data);
				g_free(meta_data);

				//Last_played_filename contains /, but because we are using sed, they must be changed to \/
				GString* string = g_string_new("");
				int i=0;
				while (last_played_filename[i])
					{
					if (last_played_filename[i]=='/')
						string = g_string_append(string,"\\/");
					else
						string = g_string_append_c(string,last_played_filename[i]);
					i++;
					}
				gchar* converted_filename = g_string_free (string, FALSE);

				gchar* cmd = g_strdup_printf("sed -i 's/\"audio-file\" : \"\\/[a-z\\/A-Z_$.]*\"/\"audio-file\" : \"%s\" /g' %s",converted_filename,filename);

				g_free(converted_filename);

				printf("Executing: '%s'\n",cmd);
				if (system(cmd))
					printf("Error, can't call '%s'\n",cmd);
				g_free(cmd);


				tangle_view_unload(TANGLE_VIEW(jammo_get_actor_by_id("fullsequencer-view")));
				clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));
				start_sequencer(filename);
				g_free(filename);
		}
	}
	}

end_backingtrack_selection();
}


void backingtrack_selection_cancel_clicked(TangleButton* tanglebutton, gpointer none){
	printf("backingtrack_selection_cancel_clicked\n");
	end_backingtrack_selection();
}

void backingtrack_up_arrow_clicked(TangleButton* tanglebutton, gpointer none){
printf("backingtrack_up_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "backingtrack-selection-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-y", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-y",old_value-130, NULL);
}


void backingtrack_down_arrow_clicked(TangleButton* tanglebutton, gpointer none){
printf("backingtrack_down_arrow_clicked\n");
	ClutterActor* scroller = jammo_get_actor_by_id( "backingtrack-selection-scroller");
	float old_value;
	g_object_get(scroller, "scrolling-offset-y", &old_value, NULL);
	clutter_actor_animate(scroller, CLUTTER_EASE_IN_OUT_QUAD, 250,"scrolling-offset-y",old_value+130, NULL);
}

