/** cem.h is part of JamMo.
License: GPLv2, read more from COPYING
*/
#ifndef _CEM_H_
#define _CEM_H_

//Log-message types. Influenced by log4j-type levels.
//LOG_TRACE   More detailed information.  //any use of this?
enum {
  LOG_NONE = 0,   /* Can be used to empty log-level*/
  LOG_DEBUG =1,   /*Detailed information on the flow through the system */
  LOG_INFO  =2,    /*Interesting runtime events (startup/shutdown) */
  LOG_FATAL =4,   /*Severe errors that cause premature termination */
  LOG_ERROR =8,   /*Other runtime errors or unexpected conditions */
  LOG_WARN  =16,    /*'Almost' errors, other runtime situations that are undesirable or unexpected */
  LOG_USER_ACTION=32,  /* Everything user is doing.*/
  LOG_NETWORK =64, /*Networking info, e.g. new connection establishments, game starting etc. */
  LOG_NETWORK_DEBUG =128 /* Networking debug */
};

void cem_add_to_log(char *message,int type);
void cem_set_log_level(int new_level);
void cem_append_to_log_level(int level);

#endif  /* _CEM_H_ */
