/** collaboration.h is part of JamMo.
License: GPLv2, read more from COPYING
*/
#ifndef _COLLABORATION_H_
#define _COLLABORATION_H_


#include <gst/gst.h>
#include <clutter/clutter.h>
#include "gems_structures.h"
#include "../meam/jammo-editing-track.h"
#include "../meam/jammo-sample.h"

typedef struct {
	int id;
	char *name;
	char *address;
	int port;
} User;
typedef struct {
	User current;
	User *next;
} UserList;

typedef struct {
	int users[4];	
} Game;

typedef struct {
	void (*add_sample)(JammoEditingTrack*, JammoSample*, guint64);
	void (*remove_sample_from)(JammoEditingTrack* track, JammoSample* sample);
	void (*theme_info)(const gchar*, int, ClutterActor*);
}Collaboration_Callback;

void collaboration_start_pair_game(gint16 theme, gint16 variation, gems_components* data);//Start a new group and game
void collaboration_pair_game_joined(gems_components* data);//Join existing group and game
void collaboration_got_song_info(gems_components* data, const gchar song_info[]);
void collaboration_member_list_updated(gems_components* data, gems_connection* element, gboolean owner);
int collaboration_create_game_server(int port, ip_communication* communicationdata);//For testing
int collaboration_create_game_client(char *address, int port, ip_communication* communicationdata);//For testing
int collaboration_create_game();//The function to be used in final product
void collaboration_handle_message(char* message,int length, int id, ip_communication* communicationdata);
int collaboration_send_to_current_group(char* message,int length, ip_communication* communicationdata);

//Functions for creating and sending messages to other users
void collaboration_add_new_sample_to_track(guint loop_id, guint slot);
void collaboration_remove_sample_from_slot(guint slot);
void collaboration_midi_events_to_track(GemsEventListOperation operation, gint16 instrument_id, GList * list);
void collaboration_slider_events_to_track(GemsEventListOperation operation, gint16 instrument_id, GList * list);
void collaboration_user_info_request(int connectionid, ip_communication* communicationdata);
void collaboration_theme_info(char* themename, int themevariation, int id, ip_communication* communicationdata);
void collaboration_request_start_game(int id, ip_communication* communicationdata);

//Functions for decoding messages from other users
int decode_add_new_sample_to_track(char* message,int length);
int decode_remove_sample_from_slot(char* message,int length);
int decode_user_info_request(char* message,int length, int id, ip_communication* communicationdata, gems_peer_profile* my_profile);
int decode_user_info_response(char* message,int length, int id);
int decode_theme_info(char* message,int length, int id);
int decode_start_game_request(char* message,int length, int id);
int decode_start_game_response(char* message,int length, int id);


//Callbacks for higher application

Collaboration_Callback* collaboration_create_callback(void (*add_sample)(JammoEditingTrack*, JammoSample*, guint64), void (*remove_sample_from)(JammoEditingTrack* track, JammoSample* sample), void (*theme_info)(const gchar*, int, ClutterActor*));


#endif  /* _COLLABORATION_H_ */

