#ifndef __PM_STORAGEAGENT_H_
#define __PM_STORAGEAGENT_H_

#include "gems_definitions.h"

#ifdef __cplusplus

#include <map>
#include <iostream>
#include <vector>
#include <iterator>
#include <glib.h>

using namespace std;

class StorageAgent 
{
public:
	// Constructor
	StorageAgent();
	// Destructor
	~StorageAgent();
	
	// Functions
	// Synchronize the data
	gboolean Synchronize();	
	
	// Retrieves the user data from the database
	// currently just creates static data
	gboolean Retrieve(guint32 userID); 
	
	// Stores the user profile data to database
	gboolean Store(guint32 userID);
	
	// Gets the details 
	string getDetails();
	
	// Gets one detail
	string getDetail(string& detail);
	
	// Set a detail
	gboolean setDetails(string& detail, string& newvalue);
	
	// Clear all the user details
	gboolean clearDetails();
	
private:
	// The map is for storing key-value pairs of user
	// profile info and an iterator for going through the data
	map<string, string> profileDetails;
	map<string, string>::const_iterator profileIterator;
	
	// This function removes the unneccesary symbols
	// From the lines read
	void Tokenize(const string& str,
			  vector<string>& tokens,
			  const string& delimiters);
};

#endif //__cplusplus

#endif /*__PM_STORAGEAGENT_H_*/

