/**midi_editor_notes.h is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This header files consists of note structures and functions to modify notes.

These structures and functions should make it easier to control notes, their properties
and visual representations.
*/

#ifndef MIDI_EDITOR_NOTES_H_
#define MIDI_EDITOR_NOTES_H_

#include <stdlib.h>
#include <stdio.h>
#include <clutter/clutter.h>
#include <glib.h>
#include "../../meam/jammo-midi.h"

//Represents a single note
typedef struct note_struct {
	ClutterActor *note_actor;
	int line_number;
	int note_position_x;
	ClutterActor *arrow_following_me;
	double start_time;
	double end_time;
	JammoMidiEvent* event; //this will take start_time too. TODO.

} Note;

typedef GPtrArray NoteArray;

NoteArray* midi_editor_notes_new_collection();
void midi_editor_notes_free_collection(NoteArray *array);
void midi_editor_notes_free_arrows(NoteArray *array);
guint midi_editor_notes_get_collection_size(NoteArray *array);

void midi_editor_notes_sort_collection(NoteArray *array);
void midi_editor_notes_sort_collection_lines(NoteArray *array);

//Note* midi_editor_notes_new_note(char note, int octave, double start_time, double end_time);
Note* midi_editor_notes_new_note_with_actor(char note, double start_time, double end_time, ClutterActor *actor, int line_number, int note_position_x);

Note* midi_editor_notes_get_note(NoteArray *array, int note_index);
Note* midi_editor_notes_get_note_from_actor(NoteArray *array, ClutterActor *actor);
ClutterActor* midi_editor_notes_get_note_actor(NoteArray *array, int note_index);
void midi_editor_notes_destroy_note(NoteArray *array, Note *note);
gboolean midi_editor_notes_set_note_time(NoteArray *array, double start_time, double end_time, ClutterActor *actor);
gboolean midi_editor_notes_remove_note_from_collection(NoteArray *array, ClutterActor *actor);
void midi_editor_notes_add_note_to_collection(NoteArray *array, Note *note);
gboolean midi_editor_notes_is_note_overlapping(NoteArray *array, Note *note);

//Debug prints for internal use
void midi_editor_notes_note_debug_print(Note *note, int myIndex);
void midi_editor_notes_collection_debug_print(NoteArray *array);
void midi_editor_notes_save_collection(NoteArray *array, gchar *filename);
void midi_editor_notes_load_collection(gchar *filename);

#endif /* MIDI_EDITOR_NOTES_H_ */
