/*
 * test-miditrackview.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */

/**********

 */

//Optional backing_track
//#define USE_BACKING_TRACK

#include <meam/jammo-meam.h>
#include <meam/jammo-playing-track.h>
#include <meam/jammo-instrument-track.h>
#include <meam/jammo-midi.h>
#include <chum/jammo-chum.h>
#include <chum/jammo-note-button.h>
#include <chum/jammo-miditrack-view.h>
#include <chum/jammo-cursor.h>
#include <tangle.h>


#ifdef USE_BACKING_TRACK
#include <meam/jammo-editing-track.h>
#endif

static const ClutterColor red = { 255, 0, 0, 128 };



static gboolean on_play_button_clicked(TangleButton* button, gpointer user_data) {
	jammo_sequencer_play(JAMMO_SEQUENCER(user_data));

	return FALSE;
}


static gboolean on_button2_clicked(TangleButton* button, gpointer user_data) {
	//Will resize total area of miditrack to (500,100).
	jammo_miditrack_view_zoom_to_fit(JAMMO_MIDITRACK_VIEW(user_data),500.0, 100.0);
	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* box;
	ClutterActor* scrolling_actor;
	ClutterActor* note_button;
	JammoSequencer* sequencer;


	JammoInstrumentTrack* track;
	ClutterActor* track_view;
	ClutterActor* texture;
	ClutterActor* cursor;
	ClutterActor* play_button, *button2;

	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);


	sequencer = jammo_sequencer_new();

	 //Optional backing_track
	#ifdef USE_BACKING_TRACK
	JammoEditingTrack* backing_track;
	JammoSample* sample;
	backing_track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track));
	sample = jammo_sample_new_from_file("/opt/jammo/themes/animal/110/backing_track.wav");
	jammo_editing_track_add_sample(backing_track, sample, 0);
	#endif

	//Instrument track
	track = jammo_instrument_track_new(2); //2=UD
	jammo_instrument_track_set_realtime(track, FALSE);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));




	stage = clutter_stage_get_default();
	#ifdef N900
	clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	#else
	clutter_actor_set_size(stage, 800.0, 480.0);
	#endif

	//Layout for button_container (box_for_buttons)
	TangleLayout* layout = tangle_box_layout_new();
	//tangle_layout_set_direction(layout, TANGLE_LAYOUT_DIRECTION_RTL);

	ClutterActor* box_for_buttons = tangle_widget_new();
	tangle_widget_set_layout(TANGLE_WIDGET(box_for_buttons), layout);
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), box_for_buttons);

	//Notes are currently added like jammo-sample-buttons (dragging from somewhere)
	note_button = jammo_note_button_new_without_events();
	clutter_actor_set_position(note_button, 0.0, 0.0);
	clutter_actor_set_size(note_button,64.0, 64.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(box_for_buttons), note_button);

	//Play-button for starting sequencer
	play_button = tangle_button_new();
	clutter_actor_set_position(play_button, 100.0, 0.0);
	tangle_widget_add_after(TANGLE_WIDGET(play_button), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(play_button, "clicked", G_CALLBACK(on_play_button_clicked), sequencer);
	clutter_container_add(CLUTTER_CONTAINER(box_for_buttons), play_button, NULL);


	//container and scrolling area for track and cursor
	box = tangle_widget_new();
	scrolling_actor = tangle_scrolling_actor_new(box);
	clutter_actor_set_position(scrolling_actor, 0.0, 80.0);
	clutter_actor_set_size(scrolling_actor, 800.0, 400.0);
	clutter_container_add(CLUTTER_CONTAINER(stage), scrolling_actor, NULL);

	//Trac 25=number of slots, duration_of_slot = 0,25s, grid_Size 64*64, notes from high..low
	track_view = jammo_miditrack_view_new(track, 25, 250000000LL, 64.0, 64.0,56,50);
	clutter_actor_set_position(track_view, 1.0, 1.0); //unless leftmost and topmost borders are not visible
	clutter_container_add_actor(CLUTTER_CONTAINER(box), track_view);



	//zoom-button
	button2 = tangle_button_new();
	clutter_actor_set_position(button2, 300.0, 0.0);
	tangle_widget_add_after(TANGLE_WIDGET(button2), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(button2, "clicked", G_CALLBACK(on_button2_clicked), track_view);
	clutter_container_add(CLUTTER_CONTAINER(box_for_buttons), button2, NULL);



	//Cursor (doesn't work if there are only instrument-track)
	texture = clutter_rectangle_new_with_color(&red);
	clutter_actor_set_size(texture, 10.0, 78.0);
	cursor = jammo_cursor_new(sequencer, texture);
	tangle_actor_set_depth_position(TANGLE_ACTOR(cursor), 1);
	clutter_actor_set_position(cursor, 0.0, 200.0);
	clutter_actor_set_size(cursor, 64.0*25, 180.0); //width=grid_width*slot_numbers, height (not used) = grid_height*(high-low)
	clutter_container_add_actor(CLUTTER_CONTAINER(box), cursor);



	//Add one note
	JammoMidiEvent* start_event = malloc(sizeof(JammoMidiEvent));
		start_event->note = 53;
		start_event->timestamp = 300000000LL;
		start_event->type = JAMMOMIDI_NOTE_ON;

	JammoMidiEvent* stop_event = malloc(sizeof(JammoMidiEvent));
		stop_event->note = 53;
		stop_event->timestamp = 350000000LL;
		stop_event->type = JAMMOMIDI_NOTE_OFF;

	jammo_miditrack_view_add_note(JAMMO_MIDITRACK_VIEW(track_view),start_event,stop_event);



	//Add events from file
	GList* events = jammomidi_file_to_glist("../../notes.txt");
	jammo_miditrack_view_add_event_list(JAMMO_MIDITRACK_VIEW(track_view),events);

	//Scaling affects grid and notes, but then dragging and dropping is not handled correctly
	//g_object_set(track_view, "transition-scale-x", 0.5, "transition-scale-y", 1.0, NULL);

	clutter_actor_show_all(stage);
	clutter_main();

	return 0;
}
