#include <math.h> //sin
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files
#include <string.h>

#include "../jammo-cursor.h"
#include "../configure.h" //e.g. DATA_DIR
#include "../jammo-sample-button.h"
#include "../jammo-track-view.h"
#include "../jammo-mentor.h"
#include "../jammo.h"


#include "chum.h"
#include "trafficlight_dialog.h"
#include "composition_game.h"


/*
This function is called when user chooses and clicks one theme in theme_selection (defined on themeselection-view.json).
Selected theme is 'name'-property of clicked button.
*/
void themeselection_theme_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	const gchar* name = clutter_actor_get_name(CLUTTER_ACTOR(source));
	
	//subthemes are 1,2,3.
	int variation = (rand () % 3) + 1;
	printf("Random variation is '%d'\n",variation);
	
	composition_game_start_theme(name,variation,jammo_get_actor_by_id("themeselection-view"));

	//This is a previous view (themeselection-view). Hide it.
	ClutterActor* old_view;
	if ((old_view = jammo_get_actor_by_id("themeselection-view"))) {
		tangle_actor_hide_animated(TANGLE_ACTOR(old_view));
	}

}
