/*This file is part of JamMo.
License:LGPL 2.1
 */

#ifndef __GST_JAMMO_SLIDER_H__
#define __GST_JAMMO_SLIDER_H__

#include <gst/gst.h>
#include <gst/base/gstbasesrc.h>

G_BEGIN_DECLS

#define GST_TYPE_JAMMO_SLIDER \
  (gst_jammo_slider_get_type())
#define GST_JAMMO_SLIDER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_JAMMO_SLIDER,GstJammoSlider))
#define GST_JAMMO_SLIDER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),GST_TYPE_JAMMO_SLIDER,GstJammoSliderClass))
#define GST_IS_JAMMO_SLIDER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_JAMMO_SLIDER))
#define GST_IS_JAMMO_SLIDER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),GST_TYPE_JAMMO_SLIDER))

typedef enum {
  GST_JAMMO_SLIDER_FORMAT_NONE = -1,
  GST_JAMMO_SLIDER_FORMAT_S16 = 0,
  GST_JAMMO_SLIDER_FORMAT_S32,
  GST_JAMMO_SLIDER_FORMAT_F32,
  GST_JAMMO_SLIDER_FORMAT_F64
} GstJammoSliderFormat;


typedef struct _GstJammoSlider GstJammoSlider;
typedef struct _GstJammoSliderClass GstJammoSliderClass;

typedef void (*JammoSliderProcessFunc) (GstJammoSlider*, guint8 *);
typedef gfloat (*JammoSliderInstrumentFunc) (gdouble);

/*If you change these:
-generate freq-table again
-check names of notes (it is array with size 12) */
#define NUMBER_OF_OCTAVES 8
#define NUMBER_OF_NOTES 12

/**
 * GstJammoSlider:
 * object structure.
 */
struct _GstJammoSlider {
  GstBaseSrc parent;

  JammoSliderProcessFunc process;

  /* parameters */
  gint instrument; 	/*Type of instrument*/
  gdouble volume;
  gboolean note_table[NUMBER_OF_OCTAVES*NUMBER_OF_NOTES];


  /* audio parameters */
  gint samplerate;
  gint samples_per_buffer;
  gint sample_size;
  GstJammoSliderFormat format;
  
  /*< private >*/
  gboolean tags_pushed;			/* send tags just once ? */
  GstClockTimeDiff timestamp_offset;    /* base offset */
  GstClockTime next_time;               /* next timestamp */
  gint64 next_sample;                   /* next sample to send */
  gint64 next_byte;                     /* next byte to send */
  gint64 sample_stop;
  gboolean check_seek_stop;
  gboolean eos_reached;
  gint generate_samples_per_buffer;	/* used to generate a partial buffer */
  gboolean can_activate_pull;
  
  /* waveform specific context data */
  gdouble accumulators[NUMBER_OF_OCTAVES*NUMBER_OF_NOTES];			/* phase angle */
  gfloat tremolo_phase;		/*Vibration of tones*/
  gfloat slider_freq;
  gfloat slider_freq_slow;
  gfloat slider_accumulator;
  gboolean slider_state;
  gint slider_rounding_counter;
  gboolean slider_first_freq;

  /* Slider ADSR */
  gint attack;
  gint decay;
  gfloat sustain;
  gint release;

  gint adsr_counter;
  gboolean released;
  gint release_counter;
  gfloat release_multiplier;
			
};

struct _GstJammoSliderClass {
  GstBaseSrcClass parent_class;
};

GType gst_jammo_slider_get_type (void);

G_END_DECLS

#endif /* __GST_JAMMO_SLIDER_H__ */
