/*
 * test-stample-button.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

/**********
 * Known bugs: Timeline is not adjusted to anything (including sample durations).
 */

#include <meam/jammo-meam.h>
#include <meam/jammo-playing-track.h>
#include <chum/jammo-chum.h>
#include <chum/jammo-sample-button.h>
#include <chum/jammo-track-view.h>
#include <chum/jammo-cursor.h>
#include <tangle.h>

static const ClutterColor red = { 255, 0, 0, 128 };

static gboolean create_new_sample(TangleButton* button, gpointer track_view) {
	ClutterActor* sample_button;
	sample_button = jammo_sample_button_new_from_files("test_image_100x74.jpg", "/opt/jammo/themes/animal/110/animalw_110_vibraslap_2.wav");
	jammo_track_view_add_jammo_sample_button(JAMMO_TRACK_VIEW(track_view), JAMMO_SAMPLE_BUTTON(sample_button), 1);
	
	return FALSE;
}

static gboolean on_play_button_clicked(TangleButton* button, gpointer user_data) {
	jammo_sequencer_play(JAMMO_SEQUENCER(user_data));

	return FALSE;
}

int main(int argc, char** argv) {
	ClutterActor* stage;
	ClutterActor* box;
	ClutterActor* scrolling_actor;
	ClutterActor* sample_button;
	JammoSequencer* sequencer;
	JammoEditingTrack* backing_track;
	JammoSample* sample;
	JammoEditingTrack* track;
	ClutterActor* track_view;
	ClutterActor* texture;
	ClutterActor* cursor;
	ClutterActor* play_button;
	ClutterActor* button_for_creating;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);

	/* TODO: remove this as jammo_track_view is fixed. */
	jammo_mentor_new(NULL, 1.0, 1.0);
	
	stage = clutter_stage_get_default();
	//clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	clutter_actor_set_size(stage, 800.0, 480.0);

	box = tangle_widget_new();
	scrolling_actor = tangle_scrolling_actor_new(box);
	clutter_actor_set_size(scrolling_actor, 800.0, 480.0);
	clutter_container_add(CLUTTER_CONTAINER(stage), scrolling_actor, NULL);

	sample_button = jammo_sample_button_new_from_files("test_image_100x74.jpg", "/opt/jammo/themes/animal/110/animalw_110_pluck_2.wav");
	clutter_actor_set_position(sample_button, 100.0, 100.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(box), sample_button);
	
	sequencer = jammo_sequencer_new();
	
	backing_track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(backing_track));
	sample = jammo_sample_new_from_file("/opt/jammo/themes/animal/110/backing_track.wav");
	jammo_editing_track_add_sample(backing_track, sample, 0);

	track = jammo_editing_track_new();
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(track));
	
	track_view = jammo_track_view_new(track, 25, 2181818182LL, 50.0);
	g_object_set(track_view, "line-every-nth-slot", 2, 
	             "disabled-slots-begin", 1,
		     "disabled-slots-end", 1, NULL);
	clutter_actor_set_position(track_view, 0.0, 200.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(box), track_view);
	
	texture = clutter_rectangle_new_with_color(&red);
	clutter_actor_set_size(texture, 10.0, 78.0);
	cursor = jammo_cursor_new(sequencer, texture);
	tangle_actor_set_depth_position(TANGLE_ACTOR(cursor), 1);
	clutter_actor_set_position(cursor, 0.0, 200.0);
	clutter_actor_set_size(cursor, 1250.0, 80.0);
	clutter_container_add_actor(CLUTTER_CONTAINER(box), cursor);
	
	play_button = tangle_button_new();
	
#ifdef animation_enabled
	ClutterAnimation* animation;
	animation = clutter_actor_animate (play_button, CLUTTER_LINEAR, 60000, "scale-y", 0.1,  NULL);
#endif
	
	clutter_actor_set_position(play_button, 700.0, 400.0);
	tangle_widget_add_after(TANGLE_WIDGET(play_button), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(play_button, "clicked", G_CALLBACK(on_play_button_clicked), sequencer);
	clutter_container_add(CLUTTER_CONTAINER(box), play_button, NULL);
	
	button_for_creating = tangle_button_new();
	clutter_actor_set_position(button_for_creating, 200.0, 400.0);
	tangle_widget_add_after(TANGLE_WIDGET(button_for_creating), clutter_texture_new_from_file("test_image_100x74.jpg", NULL), NULL, NULL, NULL);
	g_signal_connect(button_for_creating, "clicked", G_CALLBACK(create_new_sample), track_view);
	clutter_container_add(CLUTTER_CONTAINER(box), button_for_creating, NULL);
	
	clutter_actor_show_all(stage);
	clutter_main();
	
	return 0;
}
