#ifndef __GEMS_PROFILEMANAGER_H_
#define __GEMS_PROFILEMANAGER_H_

#include "StorageAgent.h"
#ifdef __cplusplus
#include <iostream>

using namespace std;

class ProfileManager {
public:
	
	// Constructor, creates a server
	// for sharing profile info over peerhood
	ProfileManager();
	// Destructor
	~ProfileManager();
	
	// Login with certain userID
	bool Login(int userId);
	// Logout
	bool Logout();
	// Show user details
	string ViewDetails();
	// Get single detail
	string ViewDetail(string detail);
	// Edit own details
	bool EditDetails(string detail, string newValue);

private:

	StorageAgent *storageAgent;
	int user;
};

#else
	typedef
		struct ProfileManager
			ProfileManager;
#endif // __cplusplus

#ifdef __cplusplus
extern "C" {
#endif

void log_wrap(char* msg, int info);
// ---------------- C API -------------------------//

/* Create new profile manager interface
 *
 * Wrapper for ProfileManager::ProfileManager() 
 *
 * Returns: a pointer to struct ProfileManager
 *
 * Use the struct only through functions described here!
 */
ProfileManager* gems_profilemanager_new_manager();


/* Delete profile manager
 *
 * Wrapper for ProfileManager::~ProfileManager() 
 *
 * Params:
 *  ProfileManager* _aManager - object to be destroyed
 */ 
void gems_profilemanager_delete_manager(ProfileManager* _aManager);


/* Login to ProfileManager
 *
 * Wrapper for bool ProfileManager::Login(int)
 *
 * Params:
 *  ProfileManager* _aManager - profile manager to use
 *  int _userId - id of the user
 *
 * Returns: int, 0 if false, 1 if true
 */
int gems_profilemanager_login(ProfileManager* _aManager, int _userId);


/* Login to ProfileManager
 *
 * Wrapper for bool ProfileManager::Logout()
 *
 * Params:
 *  ProfileManager* _aManager - profile manager to use
 *
 * Returns: int, 0 if false, 1 if true
 */
int gems_profilemanager_logout(ProfileManager* _aManager);


/* View a single detail
 *
 * Wrapper for string ProfileManager::ViewDetail(string)
 * 
 * Params:
 *  ProfileManager* _aManager - profile manager to use
 *  char* _parameter - parameter to retrieve
 *
 * Returns: char* containing the value, or empty if not found
 */
const char* gems_profilemanager_view_info(ProfileManager* _aManager,
	char* _parameter);


/* Edit own detail
 * 
 * Wrapper for bool ProfileManager::EditDetails(string, string);
 *
 * Params:
 *  ProfileManager* _aManager - profile manager to use
 *  char* _detail - Detail to be changed
 *  char* _value - Value for the detail to be changed
 *
 * Returns: int, 0 - detail was not found, 1 - detail was found (val. changed)
 */
int gems_profilemanager_edit_info(ProfileManager* _aManager, char* _parameter,
	char* _value);


/* Initialize profile with given details
 *
 * Params:
 *  ProfileManager* _aManager - profile manager to use
 *  char* _username - username to init
 *  char* _firstname - first name of the user
 *  char* _lastname - last name of the user
 *  char* _age - age of the user as characters
 *
 * Returns: int, 0 if some cannot be changed (shouldn't happen), 1 if success.
 */
int gems_profilemanager_init_info(ProfileManager* _aManager, char* _username,char* _firstname,	char* _lastname, char* _age);

/* Get own username */
const char* gems_profilemanager_get_username(ProfileManager* _aManager);

/* Get firstname */
const char* gems_profilemanager_get_firstname(ProfileManager* _aManager);

/* Get lastname */
const char* gems_profilemanager_get_lastname(ProfileManager* _aManager);

/* Get age */
const char* gems_profilemanager_get_age(ProfileManager* _aManager);

#ifdef __cplusplus
}
#endif

#endif /*__GEMS_PROFILEMANAGER_H_ */

