/*
 * cupboard.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include <fcntl.h> //we check some files

#include "singinggame.h"
#include "themeselection.h"
#include "file_helper.h"
#include <string.h>

#include "gui.h" //for chum_states
#include "chum.h" //for chum_states
#include "jammo-mentor.h"
#include "../meam/jammo-playing-track.h"

/*
When loading composing, game mode is changed to correspond loaded composing.
When we come back from composing, we want set game mode back to origin.

-1 not defined (coming from main-menu)
0=EASY
1=ADVANCED
*/
static int previous_game_mode = -1;

void cupboard_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties);
/*
It suppose filenames are formatted in this way (will seg fault if not).
folder/+theme+[123]+[ae]+date.
example:+fantasy+2+e+2010.03.11_00.03.52.txt
theme_name = city / animal / fantasy          (this is checked, affects icon graphics)
variation = 1 / 2 / 3                         (not critical, user will get empty set of samplebuttons, if use non-valid variation)
mode (easy/advanced) = e /a                   (if unclear, interpret advanced, because there can be two tracks)

But this is callback-function for icon and we do not make icon if it doesn't correspond with these rules.
 (We do not want broken icons and error messages)

*/
static gboolean cupboard_icon_clicked(TangleButton *tanglebutton, gpointer data){
	printf("Load icon pressed\n");
	//We do not want Mentor say "welcome to composing", when loading saved composing.
	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_welcome_fi.ogg");

	//We do not want Mentor to help "select theme" anymore, when player have went in composing game
	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_themeselection_welcome_fi.ogg");
	
	//We do not want Mentor to help when first samplebutton is clicked or dragged
	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_first_drag_fi.ogg");
	jammo_mentor_speak_once(jammo_mentor_get_default(), "/opt/jammo/mentor_speech/mentor_composing_first_click_fi.ogg");
	jammo_mentor_shut_up(jammo_mentor_get_default());
	
	
	ClutterActor* actor = jammo_get_actor_by_id("cupboard-view");
	clutter_actor_hide(actor);

	//We need copy because strtok overwrite.
	gchar *filename; 
	filename = g_strdup_printf("%s",(gchar*)data);
	printf("filename '%s'\n",filename); // 


	strtok(filename, "+"); //this first is directory path. No use in here.

	char* theme_name =  strtok(NULL, "+");
	char* variation_name = strtok(NULL, "+");
	char* easy  = strtok(NULL, "+");
	
	//Take current game-mode.
	if (chum_is_easy_game())
		{
		previous_game_mode=0;
		}
	else 
		{
		previous_game_mode=1;
		}
	//Change game mode to correspond loaded
	if (strncmp(easy,"e",1)==0)
		chum_set_easy_game(TRUE); //e=easy
	else //if (strncmp(easy,"a",1)==0) //it is safer to use advanced if this is not clear
		chum_set_easy_game(FALSE); //a=advanced

	themeselection_start_theme(theme_name,atoi(variation_name),jammo_get_actor_by_id("cupboard-view"));

	//This is hack.  FIXME: for some reason we can't just call this.
	g_timeout_add(100,themeselection_load,data);


	return FALSE;
}


//This is id for handler which starts sequencer after song-view is showed.
static gulong handler_id;

static void play_sequencer (TangleActor *actor, ClutterActorBox *arg1, gpointer user_data){
	printf("play_sequencer secuencer='%p'\n",user_data);
	
	printf("Disconnecting handler '%ld'\n", handler_id);
	g_signal_handler_disconnect (actor,handler_id);
	
	singinggame_start_sequencer(JAMMO_SEQUENCER(user_data));
}


static void on_sequencer_stopped(JammoSequencer* sequencer_old, gpointer none) {
	printf("Sequencer '%p' stopped\n", sequencer_old);
	//Hide all
	ClutterActor*	mainview = jammo_get_actor_by_id("main-views-widget"); //No drawing on stage anymore, use this.
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), tangle_actor_hide_animated, NULL);
	
	//Show cupboard
	ClutterActor* view = jammo_get_actor_by_id("cupboard-view");
	clutter_actor_show(view);

	//And show mentor again
	tangle_actor_show(TANGLE_ACTOR(jammo_mentor_get_default()));
	
	//printf("Unreffing sequencer '%p'\n", sequencer_old);
	g_object_unref(sequencer_old);
}

/*

*/
static gboolean cupboard_song_icon_clicked(TangleButton *tanglebutton, gpointer data){
	gchar* name=(char*)data;
	printf("Load song_icon pressed: '%s'\n",name);

	// If we have not visited in songselection, we can't use cross-button.
	//Additionally next time we go to songselection, mentor doesn't say 'welcome' (good)
	ClutterActor* songselection = jammo_get_actor_by_id("songselection-view");
	clutter_actor_show(songselection);
	clutter_actor_hide(songselection);


	//Hide mentor
	jammo_mentor_shut_up(jammo_mentor_get_default());
	//tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));
	clutter_actor_hide(CLUTTER_ACTOR(jammo_mentor_get_default()));

	//make new sequencer and add tracks to it
	JammoSequencer* sequencer = jammo_sequencer_new();
	g_signal_connect(sequencer, "stopped", G_CALLBACK(on_sequencer_stopped), NULL);

	//TODO: maybe we not should use currently selected_language, but save it too.
	gchar *filename;
	int fd;
	filename = g_strdup_printf("%s/songs/%s/comping%s.ogg", DATA_DIR,name,chum_get_selected_language());
	fd = open(filename,O_RDONLY);
	if (fd == -1) //File not found
		{  //no track for this language,. use  common comping.
		filename = g_strdup_printf("%s/songs/%s/comping.ogg", DATA_DIR,name); //try without language postfix
		}
	printf("looking for file '%s' for comping_track\n",filename);

	JammoPlayingTrack* playing_track;  
	playing_track = jammo_playing_track_new(filename);   //for comping track
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(playing_track));
	g_free(filename);



	gchar *loaded_filename;
	loaded_filename = g_strdup_printf("%s/%s.wav",SINGINGS_DIRECTORY,(char*)data);
	printf("looking for file '%s' for loaded_track\n",loaded_filename);	

	JammoPlayingTrack* playing_track2;
	playing_track2 = jammo_playing_track_new(loaded_filename);
	jammo_sequencer_add_track(sequencer, JAMMO_TRACK(playing_track2));  
	g_free(loaded_filename);



	chum_set_state_of_chum(SCREEN_FROM_CUPBOARD);


	//Hide cupboard
	ClutterActor* old_view;
	old_view = jammo_get_actor_by_id("cupboard-view");
	//tangle_actor_hide_animated(TANGLE_ACTOR(old_view));
	clutter_actor_hide(CLUTTER_ACTOR(old_view));

	//Show saved song-view
	gchar *new_name = g_strdup_printf("song-%s-view",name);
	ClutterActor* new_view;
	new_view = jammo_get_actor_by_id(new_name);	
	clutter_actor_show(new_view);

	//And start sequencer after animation is completed
	//We will disconnect this handler once it has happened, so take handler_id.
	handler_id  = g_signal_connect(new_view, "show-completed", G_CALLBACK(play_sequencer), sequencer );
	printf("handler_id '%ld'\n",handler_id);
	
	return FALSE;
}



/*
This will also check and load icons for savings.
*/
void cupboard_start_cupboard(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	//When ending composing started from cupboard, we come back to this function.
	//Set easy/advanced state back to what it was before loading compositions.
	if (previous_game_mode==0)
		chum_set_easy_game(TRUE);
	else if (previous_game_mode==1)
		chum_set_easy_game(FALSE);
	//-1 means we are not coming from composing, but from mainmenu
	//Set it to -1, if we now go to mainmenu
	previous_game_mode=-1;
		
	//Scrolling area for icons
	ClutterActor* scrolling_actor = NULL;
	
	ClutterActor* container_for_saved_icons;
	container_for_saved_icons = tangle_widget_new();
	clutter_actor_set_size(container_for_saved_icons, 210.0, 1800.0);

	//Load compositions
	gchar *filepath1;
	filepath1 = COMPOSITIONS_DIRECTORY;
	
	GList* files = file_helper_get_all_files(filepath1);

	int counter1=0;
	GList* l;
	for (l = files; l; l = l->next)
		{
		//printf("readed '%s'\n",(char*)l->data);
	
		//We need copy because strtok overwrite.
		gchar *filename; 
		filename = g_strdup_printf("%s",(gchar*)l->data);
		//printf("filename '%s'\n",filename); 

		strtok(filename, "+"); //this is directory path. No use in here.

		char* theme_name =  strtok(NULL, "+");
		char* variation_name = strtok(NULL, "+");
		char* easy  = strtok(NULL, "+");
	
		ClutterActor* icon;
		gchar* icon_filename;
		if (theme_name == NULL || variation_name == NULL || easy == NULL) //This means, we couldn't tokenizer it -> do not show it at all
			break;
		
		if (strncmp(theme_name,"fantasy",7)==0) 
		{
			icon_filename = strncmp(easy,"e",1)==0 ? "/opt/jammo/themes/fantasy/140/donkey.png" : "/opt/jammo/themes/fantasy/90/unicorn.png";
		}
		else if (strncmp(theme_name,"city",4)==0) 
		{
			icon_filename = strncmp(easy,"e",1)==0 ? "/opt/jammo/themes/city/140/bicycle.png" : "/opt/jammo/themes/city/140/motorcycle.png";
		}
		else if (strncmp(theme_name,"animal",6)==0) 
		{
			icon_filename = strncmp(easy,"e",1)==0 ? "/opt/jammo/themes/animal/90/monkey.png" : "/opt/jammo/themes/animal/90/goril.png";
		}
		else //now we have hardcoded theme names TODO.  Not correct theme name -> do not show it at all
		{
			break;
		}


		icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file(icon_filename, NULL), clutter_texture_new_from_file(icon_filename, NULL));
		g_object_set(icon,"depth-position", -1, "width", 60.0, "height", 60.0, "x", 50.0,  "y", 20+counter1*94.0, NULL);
		
		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		clutter_actor_set_reactive(icon,TRUE);
		g_signal_connect (icon, "clicked", G_CALLBACK (cupboard_icon_clicked),l->data);
		counter1++;
		}

	
	//And singings
	filepath1 = SINGINGS_DIRECTORY;

	files = file_helper_get_all_files(filepath1);

	int counter2=0;
	for (l = files; l; l = l->next)
		{
		//printf("readed '%s'\n",(char*)l->data);
		ClutterActor* icon;
		//int length_of_prefix= strlen(filepath1);

		char* name = (char*)l->data;
		//printf("name = '%s'\n",name);
		char* name1 = &name[strlen(filepath1)+1];
		//printf("name1 = '%s'\n",name1);
	
		char* name2 = malloc (20);
		strncpy( name2, name1,strlen(name1)-4);
		name2[strlen(name1)-4]='\0';
		//printf("name2 = '%s'\n",name2);

		gchar* icon_filename=g_strdup_printf("%s/songs/%s/icon.png",DATA_DIR,name2);
		//printf("looking for '%s'\n",icon_filename);
		
		icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file(icon_filename, NULL), clutter_texture_new_from_file(icon_filename, NULL));
		g_free(icon_filename);

		g_object_set(icon,"depth-position", -1, "width", 60.0, "height", 60.0, "x", 190.0,  "y", 20+counter2*94.0, NULL);

		clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), icon, NULL);
		
		clutter_actor_set_reactive(icon,TRUE);
		char* name_for_callback = malloc (20);
		strcpy(name_for_callback,name2);
		g_signal_connect (icon, "clicked", G_CALLBACK (cupboard_song_icon_clicked),name_for_callback);
		g_free(name2);
		counter2++;
		}

		int counter = counter1>counter2?counter1:counter2; //max(counter1,counter2);
		//make movable shelves
		int i;
		for (i=0;i<counter;i++)
			{
			ClutterActor* b_icon = tangle_button_new_with_background_actors(clutter_texture_new_from_file("/opt/jammo/cupboard_shelf.png", NULL), clutter_texture_new_from_file("/opt/jammo/cupboard_shelf.png", NULL));
			g_object_set(b_icon,"depth-position", -2, "width", 290.0, "height", 94.0, "x", 0.0,  "y", -1+i*94.0, NULL);
			clutter_container_add(CLUTTER_CONTAINER(container_for_saved_icons), b_icon, NULL);
			}


		//Tune size of container
		clutter_actor_set_size(container_for_saved_icons, 310.0, counter*94.0);


	//Scrolling area for icons
	scrolling_actor = tangle_scrolling_actor_new(container_for_saved_icons);
	clutter_actor_set_position(scrolling_actor,  210.0, 65.0);
	
	clutter_actor_set_size(scrolling_actor, 310.0, counter*94.0<376.0?counter*94.0:376.0);
	g_object_set(scrolling_actor,"depth-position", -1,NULL);
	clutter_container_add_actor(CLUTTER_CONTAINER(jammo_get_actor_by_id("cupboard-view")), scrolling_actor);
	
	cupboard_door_clicked(NULL,NULL,NULL,NULL);
}

void cupboard_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor;
	ClutterActor* actor2;
	ClutterAnimation* animation;
	ClutterAnimation* animation2;
	//gchar* filename;
	//JammoSample* sample;
	
	actor = jammo_get_actor_by_id("cupboard-leftdoor");
	g_assert(actor != NULL);

	actor2 = jammo_get_actor_by_id("cupboard-rightdoor");
	g_assert(actor2 != NULL);

	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 5000, "rotation-angle-y", -150.0, "x", 217.0, NULL);
		/*
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);*/
	}
	
if ((animation2 = clutter_actor_get_animation(actor2))) {
		clutter_animation_completed(animation2);
	} else {
		animation2 = clutter_actor_animate(actor2, CLUTTER_LINEAR, 5000, "rotation-angle-y", 150.0, "x", 490.0, NULL);
	}

}
