/*
 * jammo_singinggame.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>

#include "jammo-mentor.h"

#define ANGLE_OF_OPENED_DOOR 110.0
gdouble welcome_door_rotating;



void finalize_welcome(){
	if (welcome_door_rotating<=-ANGLE_OF_OPENED_DOOR) 
			return;
	printf("\nStart Finalize welcome\n");
	welcome_door_rotating=-ANGLE_OF_OPENED_DOOR;

	//just be sure, that there aren't any sounds when going next view
	jammo_sample_stop_all();

	ClutterActor* actor;

		if ((actor = jammo_get_actor_by_id("main-menu-view"))) {
		clutter_actor_show(actor);
	}
	
	//wait little bit so main-menu is visible
	g_timeout_add (1000,mentor_speech,"mentor_speech/mentor_01_fi.ogg");
}


static gboolean rotate_actor (gpointer data){
	if (welcome_door_rotating>-ANGLE_OF_OPENED_DOOR)
		{
		printf("0"); fflush(stdout);
		welcome_door_rotating-=0.8;
		clutter_actor_set_rotation(CLUTTER_ACTOR(data),CLUTTER_Y_AXIS,welcome_door_rotating,0,0,0);
		return TRUE;
		}

	finalize_welcome();
	return FALSE;
}


void welcome_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	printf("Welcome clicked\n");

	//if pressed already
	if (welcome_door_rotating<0.0)
		{
		printf("door already pressed\n");
		finalize_welcome();
		return;
		}


	printf("start door animation\n");
	ClutterActor* actor;
	
	if(!(actor = jammo_get_actor_by_id("welcome-door")))
		return;
	welcome_door_rotating=0.0;
	g_timeout_add (50,rotate_actor,actor);


	printf("start door sound\n");
	gchar* filename;
	JammoSample* sample;

	filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
	//printf("Play: %s\n", filename);
	sample = jammo_sample_new_from_file(filename);
	g_free(filename);
	jammo_sample_play(sample);
	g_object_unref(sample);
}
