/*
 * jammo_singinggame.c
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Aapo Rantalainen
 */
#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>

#include "mentor.h"

//FIXME: how to react only first time when on_transition_completed?
gboolean done=FALSE;
static void on_transition_completed(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties) {
	if (!(done)){
		ClutterActor* new_parent =  jammo_get_actor_by_id("main-menu-view");
		if (new_parent==NULL) printf("new_parent is NULL\n");
		else printf("new_parent not NULL\n");
		
		ClutterActor *temp_bear=mentor_give_temp_bear();
		clutter_container_add_actor (CLUTTER_CONTAINER (new_parent), temp_bear);

		mentor_speech(temp_bear,"mentor_speech/mentor_01_fi.ogg");

		done=TRUE;
	}
}

static void finalize_welcome(void){
	ClutterActor* actor;

	//just be sure, that there aren't any sounds when going next view
	jammo_sample_stop_all();

	if ((actor = jammo_get_actor_by_id("welcome-view"))) {
		tangle_actor_hide_animated(TANGLE_ACTOR(actor));
	}
	if ((actor = jammo_get_actor_by_id("main-menu-view"))) {
		g_object_set(actor, "transition-duration", 1500, "transition-mode", 1, NULL);
		clutter_actor_show(actor);
	}
	
	g_signal_connect(actor, "transition-completed", G_CALLBACK(on_transition_completed), NULL);
}

void welcome_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* actor;
	ClutterAnimation* animation;
	gchar* filename;
	JammoSample* sample;

	actor = jammo_get_actor_by_id("welcome-door");
	g_assert(actor != NULL);
	
	if ((animation = clutter_actor_get_animation(actor))) {
		clutter_animation_completed(animation);
	} else {
		animation = clutter_actor_animate(actor, CLUTTER_LINEAR, 2750, "rotation-angle-y", -110.0, NULL);
		g_signal_connect(animation, "completed", G_CALLBACK(finalize_welcome), NULL);
		
		filename = g_strdup_printf("%s/door_opening.wav",DATA_DIR);
		sample = jammo_sample_new_from_file(filename);
		g_free(filename);
		jammo_sample_play(sample);
		g_object_unref(sample);
	}


}
