/**instrument_mode.c is part of JamMo.
License: GPLv2, read more from COPYING

This is part of terminal gui. It reads kernel keyboard events and pass valid notes
to virtual instrument.
Reading kernel events need root access. So this migth not good idea.
There are 'failsafe' mode which read char at a time and toggle note On/Off.
*/

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/input.h>
#include <termios.h>


#include "../chum/chum.h"
#include "instrument_mode.h"
#include "terminal_jammo.h"

/*events:
struct input_event {
	struct timeval time;
	unsigned short type;
	unsigned short code;
	unsigned int value;
};
*/


#define EVENT_PATH "/dev/input/event4"
//#define EVENT_PATH "/dev/input/by-path/platform-i8042-serio-0-event-kbd"

struct input_event  current_b;

static int read_packet(int from, struct input_event *y)  {
	void* packet = NULL;
	void* packet_memcpy_result = NULL;
	int packet_size=sizeof(struct input_event);
	int size_of_packet=4*packet_size;
	int bytes_read = 0;

	packet = malloc(size_of_packet);

	if(!packet) {
		fprintf(stderr, "malloc failed\n");
		exit(1);
	}

	bytes_read = read (from, packet, size_of_packet);

	if (bytes_read < packet_size) {
		fprintf(stderr, "fread failed\n");
		exit(1);
	}

	/* obtain the full packet */
	packet_memcpy_result = memcpy(y, packet+packet_size, packet_size);
		return(1);
	
}


static int handle( struct input_event event_b) {
char note=' ';

/*these values are from input.h*/
switch (event_b.code) {
    case 2: note='1';break;
    case 3: note='2';break;
    case 4: note='3';break;
    case 5: note='4';break;
    case 6: note='5';break;
    case 30: note='a';break;
    case 48: note='b';break;
    case 46: note='c';break;
    case 32: note='d';break;
    case 18: note='e';break;
    case 33: note='f';break;
    case 34: note='g';break;
    case 103: if (event_b.value==1) chum_octave_up(); return 1;//KEY_UP
    case 108: if (event_b.value==1) chum_octave_down(); return 1;//KEY_DOWN
    case 14: //backspace
      printf("Leaving Virtual instrument mode\n");
      return 0;
    case 57: //space
	if (event_b.value==1) //only press (unless it prints two times)
	  chum_print_note_table();
      return 1;
    default: return 1;
}
if (event_b.value==1){
    //printf("pressed %c\n",note);
    chum_state_of_note(1, note);
}

else if (event_b.value==0){
    //printf("released %d\n",note);
    chum_state_of_note(0, note);
}


return 1;
}


void failsafe_mode(){
printf("This isn't cool Virtual Instrument mode where you can use keyboard like piano.\n");
printf("Give notes to toggle them on and off [c1d2ef3g4a5b]\n");
printf("Use ','  and '.' to change octave. Space to print notetable.\n");
//printf("
int ch=mygetch();

  while (1){
     //printf("key:%d\n",ch);
     switch (ch)
	{
	case ',': chum_octave_down();break;
	case '.': chum_octave_up();break;
	case ' ': chum_print_note_table();break;
	case 127: printf("Leaving instrument mode. Press backspace again.\n"); return; //backspace
	default:
	  chum_toggle_note(ch);
	}
  ch=mygetch();
  }
}

void virtual_instrument_mode () {
	int file = -1;
	struct input_event b;

	file = open(EVENT_PATH, O_RDONLY);
	if (file < 0) {
		fprintf(stderr, "\nCan't open '%s': %s\n",EVENT_PATH,strerror(errno));
		fprintf(stderr, "Maybe you have wrong event number or you need root permission.\n");
		failsafe_mode();
		return;
	}

	//turn echo off
	struct termios oldt,newt;

	tcgetattr( STDIN_FILENO, &oldt );
	newt = oldt;
	newt.c_lflag &= ~( ICANON | ECHO );
	tcsetattr( STDIN_FILENO, TCSANOW, &newt );



	while(1) {
		//printf("Reading packet...");
		if(read_packet(file,  &b)) {
			if (!handle(b))  {
			    tcsetattr( STDIN_FILENO, TCSANOW, &oldt ); //return normal key echo
			    return;
			 }
		} else printf("Skipped a packet\n");
	}

}

