/**password_screen.c is part of JamMo.
License: GPLv2, read more from COPYING

User has selected username, this is for password.
There are 9 images, each representing one digit.
Password entering begins when mouse is pressed, and finished when mouse is released.
*/
#include <glib-object.h>
#include <clutter/clutter.h>
#include "config.h"
#include "clutter_jammo.h"
#include "../chum/chum.h" //chum_go_next()

int last=-1; //We need this to check are we entering new image.
gboolean drag=FALSE;
static void motion(ClutterActor *actor, ClutterEvent *event, gpointer data){
if (drag)
  {
  int number=GPOINTER_TO_INT(data);
  if (last!=number)
    {
    last=number;
    printf("%d",number); //In real case we store this somewhere
    fflush(stdout); //Because there are no '\n' we must fflush
   }
  }
}


static void press(ClutterActor *actor, ClutterEvent *event, gpointer data){
  drag=TRUE;
  printf("STARTING\n");
  motion(actor,event,data);
}


static void release(ClutterActor *actor, ClutterEvent *event, gpointer data){
  drag=FALSE;
  printf("\nREADY\n");
  chum_go_next();
}


void show_password(){
  ClutterActor* stage =main_getStage();

  printf("\n\n\n\n\n\n");
  int count=1;
  int i;
  int j;
  for (j=0;j<3;j++) 
     {
     for (i=0;i<3;i++)
        {
        //Borders for boxes
        ClutterActor* lines=clutter_rectangle_new_with_color (get_transparency_color());
        clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(lines),get_dark_color());
        clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(lines),1);
        clutter_actor_set_size (lines, 800/3, 480/3);
        clutter_actor_set_position (lines, (800/3)*i, (480/3)*j); 
        clutter_actor_show (lines);
        clutter_container_add_actor (CLUTTER_CONTAINER (stage), lines);

        //Box=image
        ClutterActor* box = clutter_texture_new ();
        gchar* filepath1;
        filepath1 = g_strdup_printf("%s/password/passwd_%d.png", DATA_DIR, count);
        //printf("filepath=%s\n",filepath1);

        g_object_set(G_OBJECT(box), "load-async", TRUE, NULL);
        clutter_texture_set_from_file (CLUTTER_TEXTURE (box), filepath1, NULL);
        g_free(filepath1);

        clutter_actor_set_size (box, 800/3, 480/3);
        clutter_actor_set_position (box, (800/3)*i, (480/3)*j); 
        clutter_actor_show (box);
        clutter_container_add_actor (CLUTTER_CONTAINER (stage), box);
        clutter_actor_set_reactive(box, TRUE);
        g_signal_connect (box, "motion-event", G_CALLBACK (motion),GINT_TO_POINTER(count));
        g_signal_connect (box, "button-press-event", G_CALLBACK (press),GINT_TO_POINTER(count));
        g_signal_connect (box, "button-release-event", G_CALLBACK (release),NULL);
        count++;
        }
    }

}

