/*
 * jammo.c (=> main.c)
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "jammo-chum.h"
#include "../meam/jammo-meam.h"
#include <tangle.h>
#include <clutter/clutter.h>
#include <stdlib.h> 

#include "jammo-mentor.h"
static const char* search_path = "/opt/jammo";

/*
 * Note! You need Tangle Toolkit that is available here:
 *
 * http://gitorious.org/tangle
 *
 * To compile:
 * gcc -rdynamic -o jammo jammo.c jammo-*.c $(pkg-config --cflags --libs clutter-1.0 tangle gstreamer-0.10 gstreamer-base-0.10 gstreamer-controller-0.10) ../meam/libmeam.a
 *
 * Note that -rdynamic is important in order to dynamic signal handler binding to work!
 */

static ClutterScript* script;

ClutterActor* jammo_get_actor_by_id(const char* id) {
	ClutterActor* actor = NULL;

	if (!(actor = CLUTTER_ACTOR(clutter_script_get_object(script, id)))) {
		g_warning("Actor '%s' not found.", id);
	}
	
	return actor;
}





//Disable automatic screen dimming
#ifdef N900
#include <libosso.h>

void maemo_heartbeat()
{
	osso_context_t *ossocontext = NULL;
	
	ossocontext = osso_initialize("jammo", "git", 0, NULL);
	if (ossocontext==NULL)
		{
		printf("error initialization of ossocontext\n");
		}
		
	osso_display_state_on(ossocontext);     //if dimmed, this will light it again
	osso_display_blanking_pause(ossocontext);

	osso_return_t ret;
	while(TRUE)
		{
		g_usleep( 55 * G_USEC_PER_SEC );
		ret = osso_display_blanking_pause(ossocontext);
		if (ret==OSSO_OK) printf ("OSSO_OK\n");
		else if (ret==OSSO_ERROR) printf ("OSSO_ERROR\n");
		else if (ret==OSSO_INVALID) printf ("OSSO_INVALID\n");
		else printf("Unknow return\n");
		}
}
#endif

int main(int argc, char** argv) {
	TangleStylesheet* stylesheet;
	ClutterActor* stage;
	GError* error = NULL;
	GObject* object;
	ClutterActor* actor;
	
	jammo_meam_init(&argc, &argv);
	jammo_chum_init(&argc, &argv);

	if ((stylesheet = tangle_stylesheet_new_from_file("jammo"))) {
		tangle_stylesheet_set_default(stylesheet);
	}

	script = clutter_script_new();
	clutter_script_add_search_paths(script, &search_path, 1);
	if (!clutter_script_load_from_file(script, "test.json", &error)) {
		g_warning("Could not load file 'test.json': %s", error->message);

		return 1;
	}
	
	if (!(object = clutter_script_get_object(script, "main"))) {
		g_warning("Object 'main' not found from the file 'test.json'.");
		
		return 2;
	}
	
	if (!CLUTTER_IS_ACTOR(object)) {
		g_warning("Object 'main' is not ClutterActor in the file 'test.json'.");
		
		return 3;
	}
	
	actor = CLUTTER_ACTOR(object);
	
	stage = clutter_stage_get_default();

#ifdef N900
	clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
	
	pthread_t preloader_thread;
	pthread_create(&preloader_thread, NULL, maemo_heartbeat, NULL);
#else
	clutter_actor_set_size(stage, 800, 480);
#endif

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	
	clutter_actor_show(stage);
	
	clutter_main();

	return 0;
}

void jammo_quit_confirmed(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	exit(0);
}


#include "string.h"
void singinggame_duetto_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("duetto clicked. get_name: '%s'\n",name);
	
	if (strcmp(name,"duetto")==0)
			chum_set_duetto(TRUE);
	else
			chum_set_duetto(FALSE); //This could also hide language selection
	
	ClutterActor* button;
	ClutterActor* texture;
	gchar *new_name = g_strdup_printf("songselection-%s-icon-texture",name);
	 
	button = jammo_get_actor_by_id("songselection-duetto");
	texture = jammo_get_actor_by_id(new_name);
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(button), texture);
}
	
	

void singinggame_language_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	ClutterActor* ct =CLUTTER_ACTOR(source);
	const gchar* name = clutter_actor_get_name(ct);
	printf("Lan clicked. get_name: '%s'\n",name);

	chum_set_selected_language(name);
	ClutterActor* new_actor =tangle_button_get_normal_background_actor(ct);
	/*gchar* filename;
	g_object_get(G_OBJECT(new_actor), "filename", &filename, NULL);
	//filename is not readable
*/
	

	ClutterActor* button;
	ClutterActor* texture;
	gchar *new_name = g_strdup_printf("songselection-language-%s-texture", name);
	 
	button = jammo_get_actor_by_id("songselection-language");
	texture = jammo_get_actor_by_id(new_name);
	tangle_button_set_normal_background_actor(TANGLE_BUTTON(button), texture);
}


extern gboolean use_main_menu_mentor;
gboolean first_time_in_songselection = TRUE;

static void on_transition_completed2(TangleAction* action, GObject* source, const gchar* trigger, TangleProperties* properties) {
	if (first_time_in_songselection){
				use_main_menu_mentor=FALSE;
		mentor_speech("mentor_speech/mentor_06_fi.ogg");
	
	first_time_in_songselection = FALSE;
	}
}


void jammo_going_to_songselection(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
		ClutterActor* actor;
		if ((actor = jammo_get_actor_by_id("songselection-view"))) {
		g_object_set(actor, "transition-duration", 1500, "transition-mode", 2, NULL);
		clutter_actor_show(actor);
	}
	if (first_time_in_songselection)
		{
		g_signal_connect(actor, "transition-completed", G_CALLBACK(on_transition_completed2), NULL);
		}
	
}

