#include "../meam/jammo-sample.h"
#include "../chum/chum.h"  //DATA_DIR
#include <tangle.h>
#include <clutter/clutter.h>
#include "string.h"

gboolean mentor_is_talking = FALSE;
gboolean use_main_menu_mentor = TRUE; //This is hack. FIXME: use only one mentor!
/*
It is possible, that both signal and user call this in very same time
and both pass the first 'if'.
  -> this is not critical.

*/
gboolean mentor_speech_over(gpointer data){
	if (!(mentor_is_talking))
		return FALSE;
	printf("laitetaan pois mentor_is_talking\n");
	mentor_is_talking = FALSE;

	ClutterActor* mentor;
	if ((mentor = jammo_get_actor_by_id(use_main_menu_mentor?"main-menu-mentor":"songselection-mentor"))) {
		ClutterAnimation* animation;
		animation = clutter_actor_animate(mentor, CLUTTER_EASE_OUT_QUAD, 1500, "width", 78.0,  "height", 120.0, NULL);
		}

	return FALSE;
}



/*
Give filename for audio sample. DATA_DIR is added.
*/
gboolean mentor_speech(gpointer data) {
	gchar* filename;
	JammoSample* sample;

	//First stop all other mentor speaking.
	jammo_sample_stop_all(); 
	mentor_is_talking = TRUE;

	filename = g_strdup_printf("%s/%s",DATA_DIR,(char*)data);
	printf("Play: %s\n", filename);
	sample = jammo_sample_new_from_file(filename);
	g_free(filename);
	g_signal_connect(sample, "stopped", G_CALLBACK(mentor_speech_over), NULL);
	jammo_sample_play(sample);
	g_object_unref(sample);

	ClutterActor* mentor;
	if ((mentor = jammo_get_actor_by_id( use_main_menu_mentor?"main-menu-mentor":"songselection-mentor"))) {
		clutter_actor_raise_top(mentor);
		clutter_actor_show(mentor);

		ClutterAnimation* animation;
		animation = clutter_actor_animate(mentor, CLUTTER_EASE_IN_QUAD, 1500, "width", 309.0,  "height", 480.0, NULL);

	}
	else printf("mentor not found\n");

	return FALSE;
}


void mentor_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties){
	if (mentor_is_talking)
		{
		printf("mentor was talking, silence it.\n");
		jammo_sample_stop_all();   //This will trigger mentor_speech_over(NULL);
		return;
		}

	ClutterActor* mentor = CLUTTER_ACTOR(source);

	const gchar* id_of_actor;
  id_of_actor = clutter_get_script_id(G_OBJECT(mentor));
	printf("mentor. get_name: '%s'\n",id_of_actor);
	gchar* filename;
	 //we have mentor in two places.
	if (strcmp(id_of_actor,"main-menu-mentor")==0)
		{
			use_main_menu_mentor=TRUE;
		mentor_speech("mentor_speech/mentor_02_fi.ogg");
		}
	if (strcmp(id_of_actor,"songselection-mentor")==0)
		{
			use_main_menu_mentor=FALSE;
		mentor_speech("mentor_speech/mentor_22_fi.ogg");
		}

}
