/**singing_game.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the singing game. Like karaoke.
 First user sing with background music and then both 
 singing and music are played.
*/

#include <fcntl.h> //we check some files
#include <glib-object.h>
//#include <gtk/gtk.h>
#include <clutter/clutter.h>
#include "config.h"

#include <math.h> //We use sqrt

#include "jammo-texture.h"
#include "clutter_jammo.h"
#include "../chum/chum.h" //THEMES_DIR
#include "object.h"
#include "preloader.h"
#include "../meam/jammo-recording-track.h"

//This is list of actors we need.
ClutterActor *contour_star;	/*When capturing and analysing pitch*/
ClutterActor *display_freq;	/*Captured pitch in text (debug)*/
ClutterActor *group_of_songs;	/*All songs (these are clickable)*/
ClutterActor *cross;		/*For skipping stages*/
ClutterActor *background;	/*This is bottom of all*/
ClutterActor *big_image;	/*Currently played song*/
ClutterActor *language_chooser; /*Changing language for next song*/
ClutterActor *choose_finnish;
ClutterActor *choose_german;
ClutterActor *choose_english;
ClutterActor *duetto_solo;    /*for choosing is teacher's sing muted or not*/
ClutterActor *choose_duetto;
ClutterActor *choose_solo;

extern ClutterActor* star_trace;
extern JammoRecordingTrack* recording_track;
char* deprecated_selected_language;
extern ClutterActor* mentor;
extern ClutterActor *to_main_menu;

static void init_song_table();
	
/*When microphone is recording, sequencer (pipeline.c) sends captured frequence to this function.
It sends -1.0 if it can't detect frequency (or if it doesn't hear anything).
*/
void gui_visualize_contour(float frequency) {
//FIXME. this is useless, but promised in gui.h
//It now sends notification and function named 'on_pitch_detected' handles this.
}


/*
This will be more fancier some day.
*/
#define radius  5.0
static void draw_trace(int x, int y) {
	//offset: it looks like contour_star (png at this moment) is drawing line
	cogl_path_ellipse (x+5, y+15, radius, radius);
	cogl_path_stroke();
}


static void update_trace(ClutterActor *data,int x,int y){
		//printf("update_texture called\n");
		CoglHandle handle;
		CoglHandle offscreen;

		if ((handle = clutter_texture_get_cogl_texture(CLUTTER_TEXTURE(data))) == COGL_INVALID_HANDLE) 
		{
					handle = cogl_texture_new_with_size(800, 480, COGL_TEXTURE_NO_SLICING, COGL_PIXEL_FORMAT_RGBA_8888_PRE);
					g_assert(handle != COGL_INVALID_HANDLE);
					clutter_texture_set_cogl_texture(CLUTTER_TEXTURE(data), handle);
		}

		cogl_push_draw_buffer();
		offscreen = cogl_offscreen_new_to_texture(handle);
		g_assert(offscreen != COGL_INVALID_HANDLE);
		cogl_set_draw_buffer(COGL_OFFSCREEN_BUFFER, offscreen);

		cogl_set_source_color4f(1.0, 1.0, 0.1, 1.0);

		draw_trace(x,y);
		cogl_pop_draw_buffer();	
		cogl_offscreen_unref(offscreen);

		clutter_actor_queue_redraw(CLUTTER_ACTOR(data));
}


#define LEFT_MARGINAL 10
//FIXME we should handle x-axis with duration + current place of playback track.
//Now we just keep count how many signals are cathed.
int star_counter=LEFT_MARGINAL; //Some marginal from left border.
static void on_pitch_detected(JammoRecordingTrack* track, gfloat frequency, gpointer user_data) {
    if (contour_star==NULL)  //error case
		{
			printf("contour_star==NULL \n");
      return;
		}
		if (star_trace==NULL)  //error case
		{
			printf("star_trace==NULL \n");
      return;
		}
		
		star_counter+=1;
		//int Y=200; //debugging without microphone
		//int Y=(star_counter-400)*(star_counter-400)*0.001+100; //This is good for demo 
		int Y=840-(frequency*2); //frequence [220,480] -> place [480,0] //origo is on upper left corner
		//printf("contour %d\n",Y);
		//if (star_counter%10==0) //If it takes too much effort to draw it in each round.
		update_trace(star_trace,star_counter,Y);

		clutter_actor_set_position(contour_star,star_counter,Y);

    gchar* buffer0;
    if (frequency==-1.0)
        buffer0="";
    else
        buffer0 = g_strdup_printf("[%3.1lf]",frequency);
    clutter_text_set_text (CLUTTER_TEXT(display_freq),buffer0);
}

static void clear_trace(){
star_counter=LEFT_MARGINAL; //Some marginal from left border.
clutter_actor_set_position(contour_star,star_counter,10);

    CoglHandle new_texture;
    CoglTextureFlags flags = COGL_TEXTURE_NO_SLICING; //NO_SLICING is important.
    new_texture = cogl_texture_new_with_size (WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW,
                                              flags,
                                              COGL_PIXEL_FORMAT_RGBA_8888_PRE);

    clutter_texture_set_cogl_texture (CLUTTER_TEXTURE(star_trace), new_texture);
    cogl_handle_unref (new_texture);
}


/*Helper function to load background image of asked song.
FIXME. this is very similar than load_song_image
*/
static ClutterActor* load_song_background_image(int i){
  //printf("%d\n",i);
  ClutterActor* actor = clutter_texture_new ();
  gchar* filepath1;

  filepath1 = g_strdup_printf("%s/background%s.png", chum_get_song_folder(i),deprecated_selected_language );
  //printf("filepath=%s\n",filepath1);

  int fd = open(filepath1,O_RDONLY);
  if (fd == -1) //File not found
    { //try use picture.png
      filepath1 = g_strdup_printf("%s/background.png", chum_get_song_folder(i) );
      int fd = open(filepath1,O_RDONLY);
      if (fd == -1) //File not found
      {
      printf("file '%s' not found, using default\n",filepath1);
      actor = config_get_configured_actor(NULL,"default-picture");
      }
    else
      {
      g_object_set(G_OBJECT(actor), "load-async", TRUE, NULL);
      clutter_texture_set_from_file (CLUTTER_TEXTURE (actor), filepath1, NULL);
      }
    }
  else
    g_object_set(G_OBJECT(actor), "load-async", TRUE, NULL);
    clutter_texture_set_from_file (CLUTTER_TEXTURE (actor), filepath1, NULL);
  return actor;
}


/*Helper function to load image of asked song
FIXME. picture.png will be icon.png
*/
static ClutterActor* load_song_image(int i){
  //printf("%d\n",i);
  ClutterActor* actor = clutter_texture_new ();
  gchar* filepath1;

  filepath1 = g_strdup_printf("%s/picture%s.png", chum_get_song_folder(i),deprecated_selected_language);
  //printf("filepath=%s\n",filepath1);

  int fd = open(filepath1,O_RDONLY);
  if (fd == -1) //File not found
    {
    printf("file '%s' not found, using default language\n",filepath1);
    filepath1 = g_strdup_printf("%s/picture.png", chum_get_song_folder(i) );
    //printf("filepath=%s\n",filepath1);	

    int fd = open(filepath1,O_RDONLY);
    if (fd == -1) //File not found
      {
      printf("file '%s' not found, using default (not found)\n",filepath1);
      actor = config_get_configured_actor(NULL,"default-picture");
      }
    else
      {
      g_object_set(G_OBJECT(actor), "load-async", TRUE, NULL);
      clutter_texture_set_from_file (CLUTTER_TEXTURE (actor), filepath1, NULL);
      }

    }
  else
    {
    g_object_set(G_OBJECT(actor), "load-async", TRUE, NULL);
    clutter_texture_set_from_file (CLUTTER_TEXTURE (actor), filepath1, NULL);
    }
  return actor;
}


static void picture_of_song_pressed(JammoTexture *actor, ClutterEvent *event, gpointer data) {
  int i = GPOINTER_TO_INT(data);
  //g_print("pressed song number: %d \n", i);
  chum_change_to_song(i);
  gui_go_screen(SCREEN_SONG_RECORDING);
}

static void language_chosen(JammoTexture *actor, ClutterEvent *event, gpointer data){
  int i = GPOINTER_TO_INT(data);
  //g_print("pressed language number: %d \n", i);
  //Hide all language buttons
  clutter_actor_hide (choose_finnish);
  clutter_actor_hide (choose_german);
  clutter_actor_hide (choose_english);
  switch (i) {
    case 1:deprecated_selected_language="";     break;
    case 2:deprecated_selected_language="_de";  break;
    case 3:deprecated_selected_language="_en";  break;
  }
  init_song_table();
  clutter_actor_raise_top (group_of_songs);
  clutter_actor_show (group_of_songs);
}

static void language_callback(){
  //g_print("language_callback pressed\n");
  clutter_actor_raise_top (choose_finnish);
  clutter_actor_show (choose_finnish);
  clutter_actor_set_reactive(choose_finnish, TRUE);
  g_signal_connect (choose_finnish, "button-press-event", G_CALLBACK (language_chosen),GINT_TO_POINTER(1));

  clutter_actor_raise_top (choose_german);
  clutter_actor_show (choose_german);
  clutter_actor_set_reactive(choose_german, TRUE);
  g_signal_connect (choose_german, "button-press-event", G_CALLBACK (language_chosen),GINT_TO_POINTER(2));

  clutter_actor_raise_top (choose_english);
  clutter_actor_show (choose_english);
  clutter_actor_set_reactive(choose_english, TRUE);
  g_signal_connect (choose_english, "button-press-event", G_CALLBACK (language_chosen),GINT_TO_POINTER(3));
}

static void duetto_solo_chosen(ClutterTexture *actor, ClutterEvent *event, gpointer data){
  int i = GPOINTER_TO_INT(data);
  //g_print("pressed duetto_solo number: %d \n", i);
  clutter_actor_hide (choose_solo);
  clutter_actor_hide (choose_duetto);

  gchar* filepath1;
  if (i==1) { //solo pressed
    filepath1 = g_strdup_printf("%s/solo_icon.png", DATA_DIR);
  }
  else  {//duetto
    filepath1 = g_strdup_printf("%s/duetto_icon.png", DATA_DIR);
  }
  clutter_texture_set_from_file (CLUTTER_TEXTURE (duetto_solo), filepath1, NULL);

}



static void duetto_solo_callback(){
  clutter_actor_raise_top (choose_solo);
  clutter_actor_show (choose_solo);
  clutter_actor_set_reactive(choose_solo, TRUE);
  g_signal_connect (choose_solo, "button-press-event", G_CALLBACK (duetto_solo_chosen),GINT_TO_POINTER(1));

  clutter_actor_raise_top (choose_duetto);
  clutter_actor_show (choose_duetto);
  clutter_actor_set_reactive(choose_duetto, TRUE);
  g_signal_connect (choose_duetto, "button-press-event", G_CALLBACK (duetto_solo_chosen),GINT_TO_POINTER(2));

}

static void cross_pressed(){
  chum_stop_sequencer();
  chum_go_next();
}

static void init_song_table(){
  //Make one clickable image for each song
  if (group_of_songs!=NULL)
      clutter_container_remove_actor (CLUTTER_CONTAINER(clutter_actor_get_parent(CLUTTER_ACTOR(group_of_songs))), group_of_songs);	
  group_of_songs = clutter_group_new();
  int mobikid_marginal = (WIDTH_OF_WINDOW-HEIGHT_OF_WINDOW) /2; /* to make drawing area square.*/
  int mobikid_marginal_between_images = 25;  /*regardless of size of images*/

  clutter_actor_set_position (group_of_songs,0,0);
  clutter_container_add_actor (CLUTTER_CONTAINER (main_getStage()), group_of_songs);
  clutter_actor_hide (group_of_songs);

	
  GList *song_list=chum_get_all_songs();
  guint number_of_songs=g_list_length(song_list);

  //We have square area to place all images.
  double lenght_of_side = sqrt((double)number_of_songs);
  int side = (int) lenght_of_side;
  if (side*side<number_of_songs)
      side++;
  gint max_columns=side,max_rows=side;


  guint current_row = 0, current_column = 0;
  int i;
  for (i=0;i<number_of_songs;i++)
    {
    ClutterActor *actor= load_song_image(i); //gives image (real or default)
    if (actor==NULL) printf ("actor is NULL\n");

    int x=mobikid_marginal + (WIDTH_OF_WINDOW-2*mobikid_marginal)/max_columns*current_column;
    int y=HEIGHT_OF_WINDOW/max_rows*current_row;
    clutter_actor_set_position (actor,x,y+mobikid_marginal_between_images/2);
    //printf("actor number=%d, x=%d, y=%d\n",i,x,y);

    int size=(WIDTH_OF_WINDOW-2*mobikid_marginal)/max_columns -mobikid_marginal_between_images;
    clutter_actor_set_size (actor,size,size);

    current_column++;
    if( current_column >= max_columns ) 
         {
         current_column = 0;
         current_row++;
         }

    clutter_container_add_actor (CLUTTER_CONTAINER (group_of_songs), actor);
    clutter_actor_show (actor);
    clutter_actor_set_reactive(actor, TRUE);
    g_signal_connect (actor, "button-press-event", G_CALLBACK (picture_of_song_pressed), GINT_TO_POINTER(i));
    }

}

void init_singing_game(){
  printf("init singing_game\n");
  ClutterActor* stage =main_getStage();

  //This is background. We want cover all underlying stuff. 
  background =clutter_rectangle_new_with_color (get_sing_green_color());
  clutter_actor_set_size (background, WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW);
  clutter_actor_set_position (background, 0, 0); 
  clutter_actor_hide (background);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), background);

  //Text label of currently captured pitch
  display_freq=  clutter_text_new_with_text ("Liberty",""); //start with empty text
  clutter_text_set_font_name(CLUTTER_TEXT(display_freq),"Luxi Mono 18");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), display_freq);
  clutter_actor_set_position (display_freq, 100, 30); 
  clutter_actor_hide (display_freq);


  //Star moving up and down
  contour_star = config_get_configured_actor(NULL,"contour_star");
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), contour_star);
  clutter_actor_hide (contour_star);

  language_chooser = config_get_configured_actor(NULL,"language"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), language_chooser);
  clutter_actor_hide (language_chooser);
  clutter_actor_set_reactive(language_chooser, TRUE);
  g_signal_connect (language_chooser, "button-press-event", G_CALLBACK (language_callback),NULL);

  choose_finnish = config_get_configured_actor(NULL,"language_finnish"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_finnish);
  clutter_actor_hide (choose_finnish);
  choose_german = config_get_configured_actor(NULL,"language_german"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_german);
  clutter_actor_hide (choose_german);
  choose_english = config_get_configured_actor(NULL,"language_english"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_english);
  clutter_actor_hide (choose_english);

  duetto_solo = config_get_configured_actor(NULL,"duetto_solo"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), duetto_solo);
  clutter_actor_hide (duetto_solo);
  clutter_actor_set_reactive(duetto_solo, TRUE);
  g_signal_connect (duetto_solo, "button-press-event", G_CALLBACK (duetto_solo_callback),NULL);
 
  choose_solo = config_get_configured_actor(NULL,"choose_solo"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_solo);
  clutter_actor_hide (choose_solo);
  choose_duetto = config_get_configured_actor(NULL,"choose_duetto"); 
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), choose_duetto);
  clutter_actor_hide (choose_duetto);
	
  //If user want skip listening before whole song is recorded. Or song_selection before playback ends.
  cross = config_get_configured_actor(NULL,"cross");
  clutter_actor_set_reactive(cross, TRUE);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), cross);
  clutter_actor_hide(cross);
  g_signal_connect (cross, "button-press-event", G_CALLBACK (cross_pressed), GINT_TO_POINTER(1));


  //This handles all adding etc
  init_song_table(""); //TODO. check language from profile.

	//Fixaround. This must be initialized in main-thread.
	//star_trace=get_real_star_trace();

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), star_trace);
  clutter_actor_hide(star_trace);
		
		

}


void start_mobikid_play_recorded(){
		clear_trace(); //clear trace and move star to begin
		
    clutter_actor_hide (display_freq);
    clutter_actor_hide (contour_star);

    //for some reason, this cross will hide otherwise
    clutter_actor_show (cross);
    clutter_actor_raise_top (cross);
    clutter_actor_set_reactive(cross, TRUE);

    chum_play_sequencer();
}

void start_mobikid_recording(){
  printf("start_mobikid_recording starts\n");
  ClutterActor* stage =main_getStage();

  clutter_actor_hide (to_main_menu);
  clutter_actor_hide (group_of_songs);
  clutter_actor_hide (mentor);
  clutter_actor_hide (language_chooser);
  clutter_actor_hide (duetto_solo);


  //Image of currently playing song
  //FIXME 'big_image' = background
  big_image = load_song_background_image(chum_get_current_song());
  clutter_actor_set_size(big_image,WIDTH_OF_WINDOW,HEIGHT_OF_WINDOW);
  
  //changing melodic contour cursor to correspond current song
  gchar* filepath1;
  filepath1 = g_strdup_printf("%s/cursor%s.png", chum_get_song_folder(chum_get_current_song()),deprecated_selected_language );
  //printf("filepath=%s\n",filepath1);

  int fd = open(filepath1,O_RDONLY);
  if (fd == -1) //File not found
     {
     filepath1 = g_strdup_printf("%s/cursor.png", chum_get_song_folder(chum_get_current_song()) );
     int fd = open(filepath1,O_RDONLY);
     if (fd == -1) //File not found
     {
     printf("file '%s' not found, using default cursor\n",filepath1);
     contour_star = config_get_configured_actor(NULL,"contour_star");
     }
  else
     clutter_texture_set_from_file (CLUTTER_TEXTURE (contour_star), filepath1, NULL);
     }
  else
     clutter_texture_set_from_file (CLUTTER_TEXTURE (contour_star), filepath1, NULL);



  clutter_actor_show (big_image);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), big_image);

  clutter_actor_show (contour_star);
  clutter_actor_raise_top (contour_star);

  clutter_actor_show (display_freq);
  clutter_text_set_text (CLUTTER_TEXT(display_freq),"");
  clutter_actor_raise_top (display_freq);

  clutter_actor_show (cross);
  clutter_actor_raise_top (cross);
  clutter_actor_set_reactive(cross, TRUE);

  clutter_actor_show(star_trace);
  clutter_actor_raise_top (star_trace);


  //recording_track is from chum.c. on_pitch_detected uses only globals
  g_signal_connect(recording_track, "pitch-detected", G_CALLBACK(on_pitch_detected), NULL);


  printf("will start sequencer\n");
  chum_play_sequencer();
}

gboolean singing_game_is_initialized(){
  //printf("singing_game_is_initialized called. will return %d\n",singinggame_back_to_mainmenu!=NULL);
  return (cross!=NULL); //last actor
}

/*
We can come to this function
a) from game selection (main menu)
b) after one song is sung
c) when recording is cancelled
*/
void start_mobikid_selection(){
  if (!singing_game_is_initialized())
      preloader_init_this(SCREEN_SONG_SELECTION);

  //chum_stop_sequencer();
  //First start with background
  clutter_actor_raise_top (background);
  clutter_actor_show (background);
  clutter_actor_set_reactive(background, TRUE);

  //Show all song-images
  clutter_actor_raise_top (group_of_songs);
  clutter_actor_show (group_of_songs);

  clutter_actor_raise_top (mentor);
  clutter_actor_show (mentor);

  clutter_actor_raise_top (language_chooser);
  clutter_actor_show (language_chooser);

  clutter_actor_raise_top (duetto_solo);
  clutter_actor_show (duetto_solo);


  //clutter_actor_raise_top (back);
  //clutter_actor_show (back);

  clutter_actor_raise_top(to_main_menu);
  clutter_actor_show (to_main_menu);

  //If this isn't first round these can be visible. So hide them
  clutter_actor_hide (display_freq);
  clutter_actor_hide (contour_star);
  clutter_actor_hide (cross);
}
