/**midi_editor.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the midi editor.
*/

#include <glib-object.h>
#include <clutter/clutter.h>


#include "jammo-texture.h"
#include "clutter_jammo.h"
//#include "object.h"

//#include "button.h"


#include "config.h"

//dragging
gboolean is_dragging;
gint x_start_of_dragging, y_start_of_dragging, x_drag_offset, y_drag_offset;


void grid_motion(ClutterActor *actor, ClutterEvent *event, gpointer data) {
  //printf("motion\n");
  gfloat x_mouse_position_f, y_mouse_position_f;

  if (CLUTTER_IS_ACTOR(actor) && is_dragging) {
      //printf("drag\n");
      clutter_event_get_coords (event,&x_mouse_position_f, &y_mouse_position_f);
      //printf("X=%f, Y=%f\n",x_mouse_position, y_mouse_position);
      gint new_x, new_y;
      gint x_mouse_position=(gint)x_mouse_position_f;
      gint y_mouse_position=(gint)y_mouse_position_f;

          new_x=x_mouse_position + x_drag_offset;
          new_y=y_mouse_position + y_drag_offset;

      clutter_actor_set_position (CLUTTER_ACTOR(actor), new_x, new_y);
  }
}


void grid_press (ClutterActor *actor, ClutterEvent *event, gpointer data) {
  //printf("press\n");
  gfloat x_start_of_dragging_f,y_start_of_dragging_f;
  clutter_event_get_coords (event, &x_start_of_dragging_f, &y_start_of_dragging_f);

  x_start_of_dragging=(gint)x_start_of_dragging_f;
  y_start_of_dragging=(gint)y_start_of_dragging_f;

  is_dragging=TRUE;
  x_drag_offset = (clutter_actor_get_x (CLUTTER_ACTOR(actor)) - (int)x_start_of_dragging);
  y_drag_offset = (clutter_actor_get_y (CLUTTER_ACTOR(actor)) - (int)y_start_of_dragging);

  //even this object is not focused it still gets the mouse events
  clutter_grab_pointer(CLUTTER_ACTOR(actor)); 
}


void grid_released (JammoTexture *actor, ClutterEvent *event, gpointer data) {
  //printf("release\n");
  //Just to be sure.
  if (!is_dragging){
    printf("not dragging \n");
    return;
  }

  /*
  gfloat x_release_f, y_release_f;
  clutter_event_get_coords (event, &x_release_f, &y_release_f);
  gint x_release=(gint)x_release_f;
  gint y_release=(gint)y_release_f;
  */
  clutter_ungrab_pointer(); //ungrab
  is_dragging = FALSE;

}


void start_midi_editor() {
  ClutterActor* stage = main_getStage();

  // "grid" might be cluttergroup and contains grid and notes and so on.
  ClutterActor *grid;
  grid = config_get_configured_actor(NULL,"house"); //just some image
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), grid);
  clutter_actor_show (grid);
  clutter_actor_set_reactive(grid, TRUE);
  clutter_actor_set_size (grid, 5000, 5000);
  clutter_actor_set_position (grid, 10, 10);

  g_signal_connect (grid, "button-release-event", G_CALLBACK (grid_released), NULL);
  g_signal_connect (grid, "motion-event", G_CALLBACK (grid_motion), NULL);
  g_signal_connect (grid, "button-press-event", G_CALLBACK (grid_press),NULL);


  //stencil will be all other buttons and elements in editor
  ClutterActor* stencil=clutter_rectangle_new_with_color (get_transparency_color());
  clutter_actor_set_size (stencil, 800, 480);
  clutter_actor_set_position (stencil, 0, 0);
  clutter_rectangle_set_border_color(CLUTTER_RECTANGLE(stencil),get_blue_color());
  clutter_rectangle_set_border_width(CLUTTER_RECTANGLE(stencil),50);
  clutter_actor_show (stencil);  
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), stencil);
  
  //clutter_actor_raise_top (actor);
}
