/**clutter_jammo.h is part of JamMo.
License: GPLv2, read more from COPYING
*/

#ifndef _CLUTTER_JAMMO_H_
#define _CLUTTER_JAMMO_H_

#include <clutter/clutter.h>
#include "../chum/gui.h"

//this will be place_of_track1, place_of_track2 ...
#define Y_PLACE_OF_TIMELINE 360
#define WIDTH_OF_SLOT 20


ClutterColor *get_transparency_color();
ClutterColor *get_white_color();
ClutterColor *get_dark_color();
ClutterColor *get_blue_color();
ClutterColor *get_green_color();

ClutterActor* load_background(const char* theme_folder);
ClutterActor* get_drop_area();
ClutterActor* main_getStage();

void show_game_selection();
void gui_visualize_playing(int state);
void window_closed(void);

typedef struct ActorBehaviour {
	ClutterActor* actor;
	ClutterBehaviour* behaviour;
} ActorBehaviour;

#endif /* _CLUTTER_JAMMO_H_ */
