#include <tangle.h>
#include "config.h"
#include "../jammo.h"
#include <glib.h>
#include <stdlib.h>

static gint is_reset_passwd=0; 
ClutterActor *pg_login_screen_container;

gint get_is_reset_password ()
{
	return is_reset_passwd;
}

static gboolean
pg_on_main_exit (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{  
	clutter_main_quit();  
	return TRUE; 
}

static gboolean
pg_on_reset_password (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{
	is_reset_passwd=1;	
	clutter_actor_hide(pg_login_screen_container);
 	return TRUE; 
}


static gboolean
pg_on_error_screen_exit_release (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{

	extern int i_plus;
	g_print("mouse pressed\n");
	gfloat x = 0;
	gfloat y = 0;
	clutter_event_get_coords (event, &x, &y);
	i_plus = 0;
	clutter_actor_hide(CLUTTER_ACTOR(rect));
	return FALSE;
}

static gboolean
pg_on_error_screen_exit_enter(ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{
	return TRUE;
}


static gboolean
pg_on_reset_success_screen_exit (ClutterRectangle *rect, ClutterEvent *event, gpointer data)
{	
	gfloat x = 0;
 	gfloat y = 0;
  	clutter_event_get_coords (event, &x, &y);		
	clutter_actor_hide(CLUTTER_ACTOR(rect));
	clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
	clutter_actor_hide (jammo_get_actor_by_id("pen-gesture-view"));
	
	return TRUE; 
}

static gboolean
pg_on_continue_login (ClutterRectangle*actor, ClutterEvent *event, gpointer data)
{
  gfloat x = 0;
  gfloat y = 0;
  clutter_event_get_coords (event, &x, &y);
  clutter_actor_hide(pg_login_screen_container);

  return TRUE; 
}

static gboolean
pg_on_skip_passwd (ClutterRectangle*actor, ClutterEvent *event, gpointer data)
{
	
	clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
	clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
	return TRUE;
}

void pg_set_reset_success_screen(ClutterActor *stage, gchar *filename)
{
	//A container	
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *container = clutter_group_new();
  	clutter_actor_set_position (container, 0, 0);
	clutter_actor_set_size(container,800,480);
  	clutter_container_add_actor (CLUTTER_CONTAINER (stage), container);	
	clutter_actor_set_reactive (container, TRUE);


	//A Layer to achieve black opacity
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
 	clutter_actor_set_size (b_layer, 800, 480);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_opacity(b_layer,200);
  	clutter_container_add_actor (CLUTTER_CONTAINER (container), b_layer);
  	

	//Loading an error image
	gchar* pg_directory_path = PG_IMAGES_DIR;	
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	ClutterActor *reset_success_screen = clutter_texture_new_from_file (path, NULL);
	clutter_actor_set_size (reset_success_screen, 300, 200);
	clutter_actor_set_position (reset_success_screen, 250, 100);	
	clutter_actor_show (reset_success_screen);
	clutter_container_add_actor (CLUTTER_CONTAINER (container), reset_success_screen);
	clutter_actor_set_reactive (reset_success_screen, TRUE);
	g_signal_connect (container, "button-press-event", G_CALLBACK (pg_on_reset_success_screen_exit), NULL);

}

void
pg_set_error_screen(ClutterActor *stage, gchar *filename)
{
	// A container
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *container = clutter_group_new();
  	clutter_actor_set_position (container, 0, 0);
	clutter_actor_set_size(container,800,480);
  	clutter_container_add_actor (CLUTTER_CONTAINER (stage), container);	
	clutter_actor_set_reactive (container, TRUE);
	clutter_actor_set_name(container, "overlay");

	// A Layer to achieve black opacity
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
 	clutter_actor_set_size (b_layer, 800, 480);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_opacity(b_layer,200);
  	clutter_container_add_actor (CLUTTER_CONTAINER (container), b_layer);

	// Loading an error image
	gchar* pg_directory_path = PG_IMAGES_DIR;	
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	ClutterActor *error_screen = clutter_texture_new_from_file (path, NULL);
	clutter_actor_set_size (error_screen, 300, 200);
	clutter_actor_set_position (error_screen, 250, 100);	
	clutter_actor_show (error_screen);
	clutter_container_add_actor (CLUTTER_CONTAINER (container), error_screen);
	clutter_actor_set_reactive (error_screen, TRUE);

	//g_signal_connect (container, "button-press-event", G_CALLBACK (pg_on_error_screen_exit), NULL);
	g_signal_connect (container, "button-release-event", G_CALLBACK (pg_on_error_screen_exit_release), NULL);
	g_signal_connect (container, "enter-event", G_CALLBACK (pg_on_error_screen_exit_enter), NULL);
}

void
pg_set_select_option_screen(ClutterActor *stage)
{
	// Login container
	pg_login_screen_container = clutter_group_new();
  	clutter_actor_set_position(pg_login_screen_container, 0, 0);
	clutter_actor_set_size(pg_login_screen_container,800,480);
  	clutter_container_add_actor(CLUTTER_CONTAINER (stage),pg_login_screen_container);
	clutter_actor_set_reactive(pg_login_screen_container, TRUE);

	// A Layer to achieve black opacity
	ClutterColor pg_black_color = { 0x00, 0x00, 0x00, 0xff };
	ClutterActor *b_layer = clutter_rectangle_new_with_color (&pg_black_color);
	clutter_actor_set_position (b_layer, 0, 0);
	clutter_actor_set_size (b_layer, 800, 480);
	clutter_actor_set_opacity(b_layer,220);
	clutter_container_add_actor (CLUTTER_CONTAINER(pg_login_screen_container), b_layer);

	// LOGIN
	gchar* pg_directory_path = PG_IMAGES_DIR;
	gchar* filename = "login_button.png";
	gchar* path = g_build_filename (pg_directory_path, filename, NULL);
	ClutterActor *login_button = clutter_texture_new_from_file (path, NULL);
	clutter_actor_set_size (login_button, 151, 45);
	clutter_actor_set_position (login_button, 30, 200);	
	clutter_actor_show (login_button);
	clutter_container_add_actor (CLUTTER_CONTAINER(pg_login_screen_container), login_button);
	clutter_actor_set_reactive (login_button, TRUE);
	g_signal_connect (login_button, "button-press-event", G_CALLBACK (pg_on_continue_login), NULL);
	
	// RESET
	gchar* filename1="reset_button.png";
	gchar* path1 = g_build_filename (pg_directory_path, filename1, NULL);
	ClutterActor *new_button = clutter_texture_new_from_file (path1, NULL);
	clutter_actor_set_size (new_button, 151, 45);
	clutter_actor_set_position (new_button, 210, 200);	
	clutter_actor_show (new_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), new_button);
	clutter_actor_set_reactive (new_button, TRUE);
	g_signal_connect (new_button, "button-press-event", G_CALLBACK (pg_on_reset_password), NULL);

	// SKIP
	gchar* filename2="skip_button.png";
	gchar* path2 = g_build_filename (pg_directory_path, filename2, NULL);
	ClutterActor *skip_button = clutter_texture_new_from_file (path2, NULL);
	clutter_actor_set_size (skip_button, 151, 45);
	clutter_actor_set_position (skip_button, 410, 200);	
	clutter_actor_show (skip_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), skip_button);
	clutter_actor_set_reactive (skip_button, TRUE);
	g_signal_connect (skip_button, "button-press-event", G_CALLBACK (pg_on_skip_passwd), NULL);

	// EXIT
	gchar* filename3="exit_button.png";
	gchar* path3 = g_build_filename (pg_directory_path, filename3, NULL);
	ClutterActor *exit_button = clutter_texture_new_from_file (path3, NULL);
	clutter_actor_set_size (exit_button, 151, 45);
	clutter_actor_set_position (exit_button, 610, 200);	
	clutter_actor_show (exit_button);
	clutter_container_add_actor (CLUTTER_CONTAINER (pg_login_screen_container), exit_button);
	clutter_actor_set_reactive (exit_button, TRUE);
	g_signal_connect (exit_button, "button-press-event", G_CALLBACK (pg_on_main_exit), NULL);

}

void pg_set_msg_from_image(ClutterActor *stage, gchar *filename, int pos_x, int pos_y)
{
	  gchar* pg_directory_path = PG_IMAGES_DIR;	  
	  gchar* path1 = g_build_filename (pg_directory_path, filename, NULL);
	  ClutterActor *message = clutter_texture_new_from_file (path1, NULL);
	  clutter_actor_set_size (message, 200, 100);
	  clutter_actor_set_position (message, pos_x, pos_y);
	  clutter_actor_show (message);
	  clutter_container_add_actor (CLUTTER_CONTAINER (stage), message);
	  clutter_actor_set_reactive (message, TRUE);
	  
}



