#ifndef COMMUNITY_UTILITIES_H
#define COMMUNITY_UTILITIES_H


#include "../jammo.h"
#include "../../configure.h"
#include <libintl.h>

#define DESTROY_ACTOR(x) {if(x==0); else{clutter_actor_destroy(x); x = 0;}}

typedef struct forum_msg {
	gint  index;
	gchar avatar[20];
	gchar sender[20];	
	gchar title[100];
	gchar time[17];
	gchar *msg;
}message;

typedef struct {
	ClutterActor *text;
	int lineCount;
	gulong handler_id;
}TextField;

typedef struct{
	char time[19];
}time_type; 

void song_name_press_action(ClutterActor*);
void rename_loop(ClutterActor *loopName);
void play_selected_loop(ClutterActor*);
void show_song_label(ClutterActor*);
void show_music_video(ClutterActor*);
void clear_container(ClutterContainer*);
gboolean add_images_from_directory(const char* path, ClutterContainer *list, GCallback, int, int);
gboolean add_single_button(ClutterActor*, ClutterContainer*, char*, int, int, GCallback);
time_type get_current_time();
void limit_line_count(TextField *text);

#endif
