#include <tangle.h>
#include <glib-object.h>
#include <sys/time.h>
#include "community_utilities.h"
#include "../jammo.h"
#include "../../meam/jammo-sample.h"
#include <sys/types.h>
#include <dirent.h>
#include "string.h"
#include <time.h>


/*
*Function computes the length of the click.
*If the length of the click is more than 1 seconds, function to rename the item is called.
*Otherwise a function to play the appropriate music piece is called. 
*/

void song_name_press_action(ClutterActor* loopName){

	static gboolean clicked = FALSE;
	static struct timeval timePressed;
	struct timeval timeReleased;

	
	clicked = !clicked;

	if(clicked){
		gettimeofday(&timePressed, NULL);
		}
	
	else{	
		gettimeofday(&timeReleased, NULL);
		
		if(timeReleased.tv_sec-timePressed.tv_sec > 1){
	
			rename_loop(loopName);	
		} 
		else if((timeReleased.tv_sec-timePressed.tv_sec == 1) && (timeReleased.tv_usec >= timePressed.tv_usec)){
			
			rename_loop(loopName);
		
		}
	
		else{
			play_selected_loop(loopName);
	
		}
	}	
	
}


void rename_loop(ClutterActor *loopName){

	//TODO: use writing tool to rename the loop

}

void play_selected_loop(ClutterActor *loopName){
	
	//TODO: add correct loop, this one is just to test the button
	static JammoSample *sample = NULL;
	
	if(sample == NULL){
		//songName = "/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg";
		puts("Starting loop");
		sample = jammo_sample_new_from_file("/home/teppo/jammo10-jammo-data/data/jammo7-12_all/backingtracks/Sa_LaBamba_110_A.ogg");
	
		jammo_sample_play(sample);
	}
	
	else{
		puts("loop stop");
		jammo_sample_stop(sample);
		g_object_unref(sample);
		sample = NULL;
	
	}

}

void show_song_label(ClutterActor* songName){

	//TODO: show label

	puts("Showing imaginary song label");
}


void show_music_video(ClutterActor* songName){

	//TODO: play music video
	
	puts("Showing imaginary music video");

}

time_type get_current_time(){

	time_t now;
	time_type current_time;
	struct tm *ts;
	gchar temp[80];

	//to get current time and date
	now = time(NULL);

	//to format the time, "dd.mm.yy hh:mm"
	ts = localtime(&now);
	strftime(temp, 18, "%d.%m.%Y %H:%M", ts);
	strcpy(current_time.time, temp);

	return current_time;
}

void clear_container(ClutterContainer *listToClear){
	
	int i = 0;
	GList *listItems;
	
	if(listToClear != NULL){
	 	
		listItems = clutter_container_get_children(listToClear); 
		
		if(listItems != NULL){
		
			do{			
				if(i > 0)
					listItems = listItems->next;
								
				clutter_container_remove_actor(CLUTTER_CONTAINER(listToClear), CLUTTER_ACTOR(listItems->data));
				i++;
	
			}while(listItems->next != NULL);
		
		g_list_free(listItems);

		}

	}
	

	listToClear = 0;	

}

gboolean add_images_from_directory(const char* path, ClutterContainer *list, GCallback function, int width, int height){
	
	DIR* dir = 0;
	struct dirent *dirEnt = 0;		
	ClutterActor *button = 0;
	char tempPath[150];
	dir = opendir(path);
	
	if(dir == NULL)
	
		return FALSE;
	
	do{
		dirEnt = readdir(dir);
		if(dirEnt != 0){
		
				strcpy(tempPath, path);
				if(strstr(dirEnt->d_name, ".png") != NULL){
				
					add_single_button(button, list, strcat(tempPath, dirEnt->d_name), width, height, function);

					}
				
		} 		
		

	}while(dirEnt != 0);

  	closedir(dir);
	
  	return TRUE;

}	

gboolean add_single_button(ClutterActor *button, ClutterContainer *list, char* path, int width, int height, GCallback function){

	button = tangle_button_new_with_background_actor(clutter_texture_new_from_file(path, NULL));
	clutter_actor_set_name(button, path);
	clutter_container_add_actor(list, button);
	clutter_actor_set_size(button, height, width);
	g_signal_connect_swapped(button, "clicked", G_CALLBACK(function), button);

	return TRUE;
}



void limit_line_count(TextField *text){

	gchar textField[500];
	PangoLayout *layout;
	int index;
	
	strncpy(textField, clutter_text_get_text(CLUTTER_TEXT(text->text)), 499);
	textField[499] = 0;

	layout = clutter_text_get_layout(CLUTTER_TEXT(text->text));

	if(pango_layout_get_line_count(layout) > text->lineCount){

		while(pango_layout_get_line_count(layout) > text->lineCount){
			index = clutter_text_get_cursor_position(CLUTTER_TEXT(text->text));

			if(index == -1){
				textField[strlen(textField)-1] = 0;
			}else{
				textField[index] = 0;
				strcat(textField, textField+index+1);
				
				clutter_text_set_cursor_position(CLUTTER_TEXT(text->text), index == 0 ? 0 : index-1);
			}
			
			g_signal_handler_disconnect(text->text, text->handler_id);
			clutter_text_set_text(CLUTTER_TEXT(text->text), textField); 
			text->handler_id = g_signal_connect_swapped(text->text, "text-changed", (GCallback)limit_line_count, text);
			layout = clutter_text_get_layout(CLUTTER_TEXT(text->text));
		}
	}
		
}

