#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <glib/gprintf.h>
#include <clutter/clutter.h>
#include <string.h>
#include "../../gems/gems_profile_manager.h"
#include "config.h"
#include "screens.h"
#include "../jammo.h"

gint countChar(gchar *string, gchar c, int length) {
	int retval = 0;
	for (int i = 0; i < length; i++) {
		if (c == string[i])
			retval++;
	}
	if (retval > 1)
		return 0;
	else
		return 1;
}

gchar convert_to_char(int i) {
	switch (i) {
	case 1:
		return '1';
	case 2:
		return '2';
	case 3:
		return '3';
	case 4:
		return '4';
	case 5:
		return '5';
	case 6:
		return '6';
	case 7:
		return '7';
	case 8:
		return '8';
	case 9:
		return '9';
	default:
		return '0';
	}
}

gchar *pg_convert_points_to_string(int *array, int array_len) {

	int i, j, k;

	gchar *password = g_malloc((array_len + 1) * sizeof(gchar));

	for (i = 0, k = 0; i < array_len; i++) {
		j = array[i];
		password[i] = convert_to_char(j);
		k++;
	}
	password[k] = '\0';
	return password;
}

gboolean pg_save_passwd(gchar *passwd) {
	FILE *passwd_F;
	gchar *filepath = g_build_filename(configure_get_jammo_directory(),
			"/pg-passwords", NULL);
	passwd_F = fopen(filepath, "w");
	if (passwd_F == NULL) {
		g_print("Cannot open passwords file..\n");
		exit(EXIT_FAILURE);
	}
	g_fprintf(passwd_F, "%s", passwd);
	fclose(passwd_F);
	return TRUE;
}

static char *ltrim(char *s)
{
	while(isspace(*s)) s++;
	return s;
}

static char *rtrim(char *s)
{
	char* back = s + strlen(s);
	while(isspace(*--back));
	*(back+1) = '\0';
	return s;
}

/**
 * In place removal of white characters.
 */
static char *trim(char *s)
{
	return rtrim(ltrim(s));
}


gchar *pg_read_passwd_from_file() {
	FILE *passwd_F;
	gchar *filepath = g_build_filename(configure_get_jammo_directory(), "/pg-passwords", NULL);
	passwd_F = fopen(filepath, "r");
	if (passwd_F != NULL) {
		gchar *buffer = g_malloc(40 * sizeof(gchar));
		gchar* result = fgets(buffer, 20, passwd_F);
		buffer = trim(buffer);
		fclose(passwd_F);
		return buffer;
	} else {
		perror(filepath);
		return "error cannot read file";
	}
}

gboolean pg_validate_gesture(gchar *password) {
	gint i = 0;
	gint j = 0;
	i = strlen(password);
	//i=i-1;// REMOVE THE NULL AT THE END OF THE STRING
	gchar *c_array = g_malloc(i * sizeof(gchar));
	g_print("password length: %d\n", i);
	if ((i < 4) || (i > 8)) {
		g_print("password wrong size\n");
		return FALSE;
	} else {
		gint k;
		for (j = 0; j < i; j++) {
			c_array[j] = password[j];
			k = countChar(password, c_array[j], i);
			if (k == 0) {
				g_print("double char");
				return FALSE;
			}
		}
	}
	g_print("valid gesture\n");
	return TRUE;
}

gboolean pg_validate_passwd(ClutterActor *stage, gchar *password, int is_new) {

	//is_new 0 for reset password, 1 for existing password
	if (is_new == 1) {
		//VALIDATE PASSWORD MISSING 
		if (pg_validate_gesture(password)) {
			pg_save_passwd(password);
			
			/* A temporary solution for changing password at login screen - the user should be already logged
			 * in to change the password, this just discards the old profile and creates new with default data */
			// Input password and age for creating default user, uses random numbers to generate id
			gems_profile_manager_create_default_user_profile(password,9);
			
			// Authenticate
			if(gems_profile_manager_authenticate_default_user(password) == LOGIN_OK)
			{
				pg_set_reset_success_screen(stage, PG_RESET_PASSWORD_SUCCESS);
				return TRUE;
			}
			else
			{
				pg_set_error_screen(stage, PG_RESET_PASSWORD_ERROR);
				return TRUE;
			}
		} else {
			pg_set_error_screen(stage, PG_PASSWORD_ERROR);
			return TRUE;
		}

	} else {

		gchar *user_passwd;
		user_passwd = pg_read_passwd_from_file();

		g_print("Knots are => %s, File data => %s\n", password, user_passwd);

		switch(gems_profile_manager_authenticate_default_user(password))
		{
			// No profile installed (for defaultuser)
			case LOGIN_NO_PROFILE:
				// First create new profile with given password
				// TODO Check returnvalues and react
				gems_profile_manager_create_default_user_profile(password,9);
				
				// Authenticate - should always succeed, hence previous function call!
				if(gems_profile_manager_authenticate_default_user(password) == LOGIN_OK)
				{
					clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
					clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
					return TRUE;
				}
				// This shouldn't really happen since a default profile with
				// the provided password was created
				else
				{
					pg_set_error_screen(stage, PG_PASSWORD_ERROR);
					return TRUE;
				}
			
			// Login ok!
			case LOGIN_OK:
				clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
				clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
				return TRUE;
			
			// Invalid password
			case LOGIN_INVALID_PASSWORD:
				pg_set_error_screen(stage, PG_PASSWORD_ERROR);
				return TRUE;
			
			// Errorcases ...
			// TODO react to these
			case LOGIN_PROFILE_CORRUPT:
			case LOGIN_PROFILE_HASH_FAIL:
			case LOGIN_CANNOT_INIT_PASSWD:
			case LOGIN_CANNOT_INIT_SECURITY:
			case LOGIN_INVALID_PARAMS:
			default:
				// Go to error screen if other error occurs
				pg_set_error_screen(stage, PG_PASSWORD_ERROR);
				return TRUE;
		}

		if (strcmp(password, user_passwd) == 0) {
			clutter_actor_show(jammo_get_actor_by_id("main-menu-view"));
			clutter_actor_hide(jammo_get_actor_by_id("pen-gesture-view"));
		} else {
			pg_set_error_screen(stage, PG_PASSWORD_ERROR);
		}
		return TRUE;
	}
}

int *get_user_passwd() {
	//Should read passwords as strings from profiler
	//int user_id;
	//gchar *username = "Guest";
	//gchar *passworddata = "password";
	//gint dummy_login;
	
	// Login should be done right after giving password
	//user_id = gems_profile_manager_get_userid(NULL);
	//dummy_login = gems_profile_manager_login(user_id, username, passworddata);
	//if (dummy_login) {
		//g_print("DUMMY LOGIN BAD\n");
	//} else {
		//g_print("DUMMY LOGIN GOOD\n");
	//}
	
	int *pass_arr;
	pass_arr = malloc(4 * sizeof *pass_arr);
	pass_arr[0] = 1;
	pass_arr[1] = 2;
	pass_arr[2] = 3;
	pass_arr[3] = 6;
	return pass_arr;
}

