#include <stdlib.h>
#include <gmodule.h>
#include <tangle.h>
#include "createALLknots.h"

#include "../../configure.h"

//Make it an object - maybe be done

#define NUM_OF_KNOTS 9

void make_reactive_all_knots(ClutterActor **matrix, gint size, gboolean make_reactive) {
	int i;
	for (i = 0; i < size; i++)
		clutter_actor_set_reactive(matrix[i], make_reactive ? TRUE : FALSE);
}

/**
 * Matrix is a handle for all knot points.
 */
void create_all_knots(ClutterActor *parent, ClutterActor **matrix, gpointer on_spot_enter, gpointer verify_path) {
	int i, j, index = 1;
	for (i = 30; i < 370; i += 160) {
		for (j = 30; j < 370; j += 160) {
			matrix[index] = create_points_with_pos(parent, j, i);
			clutter_actor_set_name(matrix[index], g_strdup_printf("%i", index)); /* so alex's code works. */
			g_signal_connect (matrix[index],"enter-event", G_CALLBACK (on_spot_enter), parent);
			g_signal_connect(matrix[index], "button-release-event", G_CALLBACK (verify_path), parent);
			index++;
		}
	}

}

ClutterActor* create_knot_with_pos(ClutterActor *stage, gint pos_x, gint pos_y) {
	ClutterColor *knot_color;
	knot_color = clutter_color_new(0xFC, 0x5E, 0xD5, 224);
	ClutterActor *knot = clutter_rectangle_new_with_color(knot_color);
	clutter_actor_set_size(knot, 40, 40);
	clutter_actor_set_position(knot, pos_x, pos_y);
	clutter_container_add_actor(CLUTTER_CONTAINER (stage), knot);
	clutter_actor_show(knot);
	clutter_actor_set_opacity(knot, 0);
	clutter_actor_set_reactive(knot, TRUE);
	return knot;
}

// The nine points
ClutterActor *create_points_with_pos(ClutterActor *stage, gint pos_x, gint pos_y) {
	gchar* directory_path1 = DATA_DIR "/password/";
	gchar* filename1 = "sphere.png";
	gchar* path1 = g_build_filename(directory_path1, filename1, NULL);
	ClutterActor *point = clutter_texture_new_from_file(path1, NULL);
	clutter_actor_set_size(point, 60, 60);
	clutter_actor_set_position(point, pos_x, pos_y);
	clutter_actor_show(point);
	clutter_container_add_actor(CLUTTER_CONTAINER (stage), point);
	clutter_actor_set_reactive(point, TRUE);
	return point;
}
