/*
 *
 * This file is part of JamMo.
 *
 * (c) 2009-2010 University of Oulu
 *
 * Authors: Henrik Hedberg <henrik.hedberg@oulu.fi>
 */

#include "../configure.h"
#include "jammo-chum.h"
#include "../meam/jammo-meam.h"
#include "jammo-mentor.h"
#include "jammo-mentor-action.h"
#include "jammo-track-view.h"
#include <tangle.h>
#include <clutter/clutter.h>
#include <stdlib.h> 
#include <libgen.h>

#include "jammo-mentor.h"

#include <fcntl.h> //we check some files

#include <string.h>

#include "configure.h"

#include "../cem/cem.h"
//used for commandline starting
#include "3-6gui/chum.h"
#include "7-12gui/midi_editor.h"
#include "7-12gui/sequencer.h"
#include "7-12gui/startmenu.h"
#include "7-12gui/communitymenu.h"
#include "7-12gui/gamesmenu.h"

#include "jammo-game-task.h"
#include "jammo-game-level.h"
#include "jammo-game-level-view.h"

#include "../gems/gems.h"
//#include "singinggame.h"

#include <libintl.h> //For gettext


#ifdef N900
#include <libosso.h>
#include <clutter/x11/clutter-x11.h>
#endif

//This is defined in welcome.c and will executed if nothing happens after 10 seconds
void welcome_door_clicked(TangleAction *action, GObject *source, const gchar *trigger, TangleProperties *properties);
static gboolean door_timeouts(gpointer data);

static ClutterScript* script;

ClutterActor* jammo_get_actor_by_id(const char* id) {
	ClutterActor* actor = NULL;

	if (!(actor = CLUTTER_ACTOR(clutter_script_get_object(script, id)))) {
		g_warning("Actor '%s' not found.", id);
	}
	
	return actor;
}

GObject* jammo_get_object_by_id(const char* id) {
	GObject* object = NULL;

	if (!(object = clutter_script_get_object(script, id))) {
		g_warning("Object '%s' not found.", id);
	}
	
	return object;
}

/* A TangleStylesheet directory is tried to load from the following locations:
 * 	DATA_DIR
 * 	<current_working_directory>/data/stylesheet
 */
static TangleStylesheet* get_jammo_stylesheet(void) {
	TangleStylesheet* stylesheet;
	gchar* cwd;
	gchar* filename;
	
	cwd = g_get_current_dir();
	filename = g_build_filename(cwd, "data", "stylesheet", NULL);

	if (g_file_test(filename, G_FILE_TEST_EXISTS)) {
		stylesheet = tangle_stylesheet_new_from_file(filename);
	} else {
		gchar *filename2 = g_build_filename(DATA_DIR, "stylesheet", NULL);
		stylesheet = tangle_stylesheet_new_from_file(filename2);
		g_free(filename2);
	}

	g_free(cwd);
	g_free(filename);

	return stylesheet;
}

/* JSON files and content within those are searched from the following locations:
 * 	DATA_DIR
 * 	<current_working_directory>/data/jammo
 */
static void add_search_paths(ClutterScript* script) {
	const gchar* default_search_path = DATA_DIR;
	const gchar* default_search_path_audio = AUDIO_DIR;
	gchar* development_search_path3_6;
	gchar* development_search_path7_12;
	gchar* cwd;
	const gchar* search_paths[4];

	cwd = g_get_current_dir();
	development_search_path3_6 = g_build_filename(cwd, "data", "jammo3_6", NULL);
	development_search_path7_12 = g_build_filename(cwd, "data", "jammo7_12", NULL);

	search_paths[0] = development_search_path3_6;
	search_paths[1] = development_search_path7_12;
	search_paths[2] = default_search_path;
	search_paths[3] = default_search_path_audio;
	clutter_script_add_search_paths(script, search_paths, G_N_ELEMENTS(search_paths));

	/* Remember to keep the paths above and below in sync! */
	
	tangle_add_search_path(development_search_path3_6);
	tangle_add_search_path(development_search_path7_12);
	tangle_add_search_path(default_search_path);
	tangle_add_search_path(default_search_path_audio);

	g_free(cwd);
	g_free(development_search_path3_6);
	g_free(development_search_path7_12);
}

#ifdef N900

static gboolean pause_display_blanking(gpointer user_data) {
	osso_context_t* osso_context;
	
	osso_context = (osso_context_t*)user_data;
	
	g_return_val_if_fail(osso_display_blanking_pause(osso_context) == OSSO_OK, FALSE);
	
	return TRUE;
}

static gint rpc_callback(const gchar* interface, const gchar* method, GArray* arguments, gpointer user_data, osso_rpc_t* retval) {
	ClutterStage* stage;
	Display* display;
	Window window;
	XEvent event;

	stage = CLUTTER_STAGE(user_data);
	
	if (!strcmp(interface, "org.umsic.jammo") && !strcmp(method, "top_application")) {
		display = clutter_x11_get_default_display();
		window = clutter_x11_get_stage_window(stage);

		XRaiseWindow(display, window);
		/* Fremantle window manager does not obey XRaiseWindow, but reacts on _NET_ACTIVE_WINDOW messages. */
		event.xclient.type = ClientMessage;
		event.xclient.message_type = XInternAtom(display, "_NET_ACTIVE_WINDOW", False);
		event.xclient.display = display;
		event.xclient.window = window;
		event.xclient.format = 32;
		event.xclient.data.l[0] = 1;
		event.xclient.data.l[1] = clutter_x11_get_current_event_time();
		event.xclient.data.l[2] = None;
		event.xclient.data.l[3] = 0;
		event.xclient.data.l[4] = 0;
		XSendEvent(display, clutter_x11_get_root_window(), False, SubstructureNotifyMask | SubstructureRedirectMask, &event);
	}
	
	retval->type = DBUS_TYPE_INVALID;
	
	return OSSO_OK;
}
#endif

/* Be sure there are needed place to save compositions and singings.
 */
static void create_directories(void) {
	gchar* cmd;
	gchar* message;

	gchar* compositions_directory = configure_get_compositions_directory();
	cmd= g_strdup_printf("mkdir -p %s",compositions_directory);
	if (system(cmd)) {
		message = g_strdup_printf("Can't call '%s' ", cmd);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);
	}
	g_free(cmd);

	cmd= g_strdup_printf("mkdir -p %s/7-12",compositions_directory); //Compositions for 7-12 game
	if (system(cmd)) {
		message = g_strdup_printf("Can't call '%s' ", cmd);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);;
	}
	g_free(cmd);

	g_free(compositions_directory);
	gchar* singings_directory = configure_get_singings_directory();

	cmd = g_strdup_printf("mkdir -p %s",singings_directory);
	if (system(cmd)) {
		message = g_strdup_printf("Can't call '%s' ", cmd);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);
	}
	g_free(cmd);
	
	cmd = g_strdup_printf("mkdir -p %s/wavs",singings_directory);
	if (system(cmd)) {
		message = g_strdup_printf("Can't call '%s' ", cmd);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);;
	}
	g_free(cmd);

	g_free(singings_directory);

	//This is not directory but file!
	gchar* jammo_directory = configure_get_jammo_directory();
	cmd = g_strdup_printf("touch %s/pg-passwords",jammo_directory);
	if (system(cmd)) {
		message = g_strdup_printf("Can't call '%s' ", cmd);
		cem_add_to_log(message, J_LOG_ERROR);
		g_free(message);
	}
	g_free(cmd);
	g_free(jammo_directory);

}

int main(int argc, char** argv) {
#ifdef N900
	osso_context_t* osso_context;
#endif

	cem_set_log_level(J_LOG_DEBUG
		+J_LOG_INFO
		+J_LOG_FATAL
		+J_LOG_ERROR
		+J_LOG_WARN
		+J_LOG_USER_ACTION
		+J_LOG_NETWORK
		+J_LOG_NETWORK_DEBUG
		+J_LOG_MENTOR_SPEECH);

	gchar* message = g_strdup_printf("JamMo-%s started",VERSION);
	cem_add_to_log(message, J_LOG_INFO);
	g_free(message);
	message = g_strdup_printf("JamMo compiled at %s %s", __DATE__, __TIME__);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);

	TangleStylesheet* stylesheet;
	gchar* filename;
	ClutterActor* stage;
	GError* error = NULL;
	GObject* object;
	ClutterActor* actor;
	ClutterColor black = { 0, 0, 0, 255 };
	gchar* application_name;
	const gchar* duration_cache_filename;

	//Name of binary
	application_name = g_path_get_basename(argv[0]);
	if (!strcmp(application_name, "jammo7_12") || (argc>=2 && strcmp(argv[1],"sequencer")==0)) {
		duration_cache_filename = "jammo7_12.duration_cache";
	} else {
		duration_cache_filename = "jammo3_6.duration_cache";
	}

	jammo_meam_init(&argc, &argv, duration_cache_filename);
	jammo_chum_init(&argc, &argv);
	
	/* GEMS initialization and profile manager test */
#ifdef NETWORKING_ENABLED
	//GRand* grand = g_rand_new_with_seed(time(NULL));
	jammo_gems_init(argc, argv);
	//gems_profile_manager_login(g_rand_int(grand),NULL,NULL);
	//printf("Selected random ID = %u\n",gems_profile_manager_get_userid(NULL));
	//g_rand_free(grand);
	
	gems_enable_network_timeout_functions();
	
	/*g_timeout_add_full(G_PRIORITY_DEFAULT_IDLE,200,(GSourceFunc)gems_process_connections, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_DEFAULT_IDLE,200,(GSourceFunc)gems_service_jammo_process_connections, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_LOW,200,(GSourceFunc)gems_communication_search_jammos, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_LOW,300,(GSourceFunc)gems_communication_retrieve_profiles, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_DEFAULT,100,(GSourceFunc)gems_communication_process_connections, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_LOW,200,(GSourceFunc)gems_communication_request_groups, NULL, NULL);
	g_timeout_add_full(G_PRIORITY_LOW,350,(GSourceFunc)gems_communication_sanitize_grouplist, NULL, NULL);*/
#endif

	srand (time (NULL)); //We will use rand()



#ifdef N900
	if (!strcmp(application_name,"jammo7_12"))
		osso_context = osso_initialize("org.umsic.jammo7_12", VERSION, 0, NULL);
	else
		osso_context = osso_initialize("org.umsic.jammo3_6", VERSION, 0, NULL);

	g_assert(osso_context != NULL);

	osso_display_state_on(osso_context);
	osso_display_blanking_pause(osso_context);
	
	g_timeout_add(55000, pause_display_blanking, osso_context);
#endif

	create_directories();

	/* PACKAGE from configure.ac */ \
	setlocale ( LC_ALL, "" );
	bindtextdomain ( PACKAGE, "/opt/jammo/languages" );
	textdomain ( PACKAGE );

	/* TRANSLATORS: This is used on main, when gettext is first time used */
	gchar* localized = g_strdup_printf("main: %s",_("gettext initialized"));
	message = g_strdup_printf("%s",localized);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);

	/* TODO: Temporary: make sure Mentor classes exists. */
	/* And orientation games related */
	message = g_strdup_printf("%ld %ld %ld %ld %ld %ld", (long)JAMMO_TYPE_MENTOR, (long)JAMMO_TYPE_MENTOR_ACTION, (long)JAMMO_TYPE_TRACK_VIEW,  (long)JAMMO_TYPE_GAME_TASK,  (long)JAMMO_TYPE_GAME_LEVEL,  (long)JAMMO_TYPE_GAME_LEVEL_VIEW);
	cem_add_to_log(message, J_LOG_NONE); //This doesn't do anything.
	g_free(message);

	if ((stylesheet = get_jammo_stylesheet())) {
		tangle_stylesheet_set_default(stylesheet);
	}

	gchar* name_of_main_json = "jammo3_6.json";
	if (!strcmp(application_name,"jammo7_12") || (argc>=2 && strcmp(argv[1],"sequencer")==0))
			name_of_main_json="jammo7_12.json";

	//printf("looking id:main from file '%s'\n",name_of_main_json);

	script = clutter_script_new();
	add_search_paths(script);
	if (!(filename = clutter_script_lookup_filename(script, name_of_main_json))) {
		g_critical("File '%s' not found.",name_of_main_json);
		
		return 1;
	}
	if (!clutter_script_load_from_file(script, filename, &error)) {
		g_warning("Could not load file '%s': %s", filename, error->message);

		return 2;
	}
	g_free(filename);
	
	if (!(object = clutter_script_get_object(script, "main"))) {
		g_warning("Object 'main' not found from the file '%s'.",name_of_main_json);
		
		return 3;
	}
	
	if (!CLUTTER_IS_ACTOR(object)) {
		g_warning("Object 'main' is not ClutterActor in the file '%s'.",name_of_main_json);
		
		return 4;
	}
	
	actor = CLUTTER_ACTOR(object);
	
	stage = clutter_stage_get_default();
	clutter_stage_set_title(CLUTTER_STAGE(stage), "JamMo");
	clutter_stage_set_color(CLUTTER_STAGE(stage), &black);
	clutter_stage_set_key_focus(CLUTTER_STAGE(stage), NULL);

#ifdef N900
	g_assert(osso_rpc_set_default_cb_f(osso_context, rpc_callback, stage) == OSSO_OK);
	
	clutter_stage_set_fullscreen(CLUTTER_STAGE(stage), TRUE);
#else
	clutter_actor_set_size(stage, 800, 480);
#endif

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), actor);
	
	clutter_actor_show(stage);

	//do not show mentor on startup
	clutter_actor_hide(CLUTTER_ACTOR(jammo_mentor_get_default()));

	gchar* lang = getenv ("LANG");
	message = g_strdup_printf("getenv(LANG)='%s'",lang);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);



	gchar* lang2=g_strndup (lang,5); //omit charset.
	gchar* path;
	if (!strcmp(application_name,"jammo7_12"))
		path = g_strdup_printf("mentor_speech7_12/%s/mentor",lang2); //TODO: one 'useless' mentor-folder
	else
		path = g_strdup_printf("mentor_speech/%s/mentor",lang2); //TODO: one 'useless' mentor-folder

	message = g_strdup_printf("mentor language path='%s' ",path);
	cem_add_to_log(message, J_LOG_DEBUG);
	g_free(message);

	jammo_mentor_set_language(jammo_mentor_get_default(),path);
	g_free(path);


	if (!strcmp(application_name,"jammo3_6")) { //start jammo 3-6 years
		cem_add_to_log("Will start 3-6 years game", J_LOG_DEBUG);
		g_timeout_add(10, start_3_6_game,NULL);
		g_timeout_add(10000, door_timeouts,NULL); //10 seconds and door will be opened automatically
	}

	else if (!strcmp(application_name,"jammo7_12")) { //start jammo 7-12 years
		cem_add_to_log("Will start 7-12 years game", J_LOG_DEBUG);
	}

	//These are only debug shortcuts:
	//Started with name jammo: check commandline parameters
	else {
// 		if (argc==2 && strcmp(argv[1],"editor")==0) {
// 			midi_editor_start_with_filename(NULL);
// 		}
// 		else if (argc==3 && strcmp(argv[1],"editor")==0) {
// 			midi_editor_start_with_filename(argv[2]);
// 		}
		if (argc==2 && strcmp(argv[1],"sequencer")==0) {
			clutter_actor_show(jammo_get_actor_by_id("fullsequencer-view"));
			clutter_actor_hide(jammo_get_actor_by_id("startmenu-view"));
		}
// 		else if (argc==2 && strcmp(argv[1],"gamesmenu")==0) {
// 			start_gamesmenu();
// 		}
// 		else if (argc==2 && strcmp(argv[1],"communitymenu")==0) {
// 			start_communitymenu();
// 		}
		else { //Do not use this with commandline parameters
			g_timeout_add(10, start_3_6_game,NULL);
			g_timeout_add(10000, door_timeouts,NULL); //10 seconds and door will be opened automatically
		}
	}

	g_free(application_name);
	clutter_main();

	g_object_unref(script);
	g_object_unref(stylesheet);
	
	jammo_meam_cleanup();

#ifdef NETWORKING_ENABLED
	/* PM logout */
	gems_profile_manager_logout();
	
	/* GEMS cleanup */
	jammo_gems_cleanup();
#endif

	jammo_cem_cleanup();
	return 0;
}
static gboolean door_timeouts(gpointer data){
//printf("door_timeouts\n");
welcome_door_clicked(NULL,NULL,NULL,NULL);
return FALSE;
}


